#include <GL/glut.h>
#ifdef XMESA
#include <GL/xmesa.h>
#endif

#include "U.h"
#include "png.h"
#include "pngio.h"
#include "texfont.h"
#include "dwchrono.h"
#include "glutint.h"

/* 
 * Physical parameters and various const
 */
/* this is the bunch of ugly globals */
typedef struct globalContext {
  /* window and perspective settings */
  Int32 win;
  Int32 winOrigX, winOrigY, winWidth, winHeight;
  UBool fullScreen;
  int frameNb;
  int res;
  DWChrono chrono[3];
} globalContext;


globalContext gc;


/* this part is automaticaly updated, do NOT edit below */
/**************************************************************** Prototypes */


/************************************************************ End Prototypes */
/* end of automaticaly updated part */

Module void
drawStart(void){
  glClearColor(.1,.1,.1,0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(90, gc.winWidth / (float) gc.winHeight, 0.1, 10);
  gluLookAt(1,1,1, 0, 0, 0, 0, 0, 1);
  glMatrixMode(GL_MODELVIEW);
  
  glRotatef(.3, 0, 1, 0);
  glRotatef(.7, 0, 0, 1);
  glRotatef(1, 1, 0, 0);
}

Module void
drawTri(void)
{  
  glDisable(GL_LIGHTING);
  glEnable(GL_LINE_SMOOTH);
  glBegin(GL_LINES);
  glColor4f(1, 0, 0, 1);
  glVertex3f(0, 0, 0);
  glVertex3f(1, 0, 0);
  glColor4f(0, 1, 0, 1);
  glVertex3f(0, 0, 0);
  glVertex3f(0, 1, 0);
  glColor4f(0, 0, 1, 1);
  glVertex3f(0, 0, 0);
  glVertex3f(0, 0, 1);
  glEnd();
  glDisable(GL_LINE_SMOOTH);
}

Module void
drawMore(double res)
{  
  Int32 i, j;
  Float32 xi, yi, x1, x2, y;

  glEnable(GL_LIGHTING);
  glNormal3f(0, 0, 1);
  xi = 1 / res;
  yi = 1 / res;
  x1 = -.5;
  x2 = x1 + xi;
  for (i = 0; i < res; i++) {
    glBegin(GL_QUAD_STRIP);
    y = -.5;
    for (j = 0; j <= res; j++) {
      glVertex3f(x1, y, 0);
      glVertex3f(x2, y, 0);
      y += yi;
    }
    glEnd();
    x1 = x2;
    x2 += xi;
  }
}





Module void
doTest(void)
{
  unsigned long ms;
  int i;


  DWChronoReset(&gc.chrono[0], DWChronoReal);
  printf("run for %d frames\n",gc.frameNb);
  for (i = 0; i < gc.frameNb; i++) {
    DWChronoReset(&gc.chrono[1], DWChronoReal);
    drawStart();
    drawTri();
    drawMore(gc.res);
    printf("\ndraw:");
    DWMSPrint(DWChronoGet(&gc.chrono[1]), NULL, 0);

    DWChronoReset(&gc.chrono[1], DWChronoReal);
    glXSwapBuffers(__glutDisplay,__glutCurrentWindow->renderWin);
    printf("\nidle:");
    DWMSPrint(DWChronoGet(&gc.chrono[1]), NULL, 0);
  }
  printf("\nwhole:");
  ms = DWChronoGet(&gc.chrono[0]);
  DWMSPrint(ms, NULL, 0);
  printf(" -> %6.2f fps\n", ((double) 1000*gc.frameNb)/ms);
}


Module void
initGc(int *argc, char **argv)
{
  Int32 i;

  /*
   * Default settings 
   */

  bzero(&gc, sizeof(gc));

  gc.frameNb = atoi(argv[1]);
  gc.res = atoi(argv[2]);

  /* window and perspective settings */
  gc.win = 0;
  gc.winOrigX = 0;
  gc.winOrigY = 0;
  gc.winWidth = 800;
  gc.winHeight = 600;
  gc.fullScreen = 1;

  /* stats */
  for (i = 0; i < (sizeof(gc.chrono) / (sizeof(gc.chrono[1]))); i++) {
    DWChronoReset(&gc.chrono[i], DWChronoReal);
  }
}

/* OpenGL settings 
 */
Module void
initOGL(void)
{
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glMatrixMode(GL_MODELVIEW);
  glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
  glDisable(GL_AUTO_NORMAL);
  glDisable(GL_NORMALIZE);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

World int
main(int argc, char **argv)
{

  initGc(&argc, argv);
  glutInitWindowPosition(gc.winOrigX, gc.winOrigY);
  glutInitWindowSize(gc.winWidth, gc.winHeight);
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);

  if (!(gc.win = glutCreateWindow("OpenGL Ploter"))) {
    fprintf(stderr, "Error opening a window.\n");
    exit(-1);
  }
#ifdef XMESA
  XMesaSetFXmode(gc.fullScreen ? XMESA_FX_FULLSCREEN : XMESA_FX_WINDOW);
#endif

  initOGL();

  doTest();
  return 0;
}
