#ifndef TEXFONT_H
#define TEXFONT_H

#include "GL/gl.h"

#define TXF_FORMAT_BYTE		0
#define TXF_FORMAT_BITMAP	1

typedef struct {
  unsigned short c;		/* Potentially support 16-bit glyphs. */
  unsigned char width;
  unsigned char height;
  signed char xoffset;
  signed char yoffset;
  signed char advance;
  char dummy;			/* Space holder for alignment reasons. */
  short x;
  short y;
} TexGlyphInfo;

typedef struct {
  GLfloat t0[2];
  GLshort v0[2];
  GLfloat t1[2];
  GLshort v1[2];
  GLfloat t2[2];
  GLshort v2[2];
  GLfloat t3[2];
  GLshort v3[2];
  GLfloat advance;
} TexGlyphVertexInfo;

typedef struct {
  GLuint texobj;
  int tex_width;
  int tex_height;
  int max_ascent;
  int max_descent;
  int num_glyphs;
  int min_glyph;
  int range;
  unsigned char *teximage;
  TexGlyphInfo *tgi;
  TexGlyphVertexInfo *tgvi;
  TexGlyphVertexInfo **lut;
} TexFont;

/* this part is automaticaly updated, do NOT edit below */
/**************************************************************** Prototypes */


/* Copyright (C) 1992 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If
   not, write to the Free Software Foundation, Inc., 675 Mass Ave,
   Cambridge, MA 02139, USA.  */


extern char *txfErrorString(void);

extern TexFont *txfLoadFont(char *filename);

extern GLuint txfEstablishTexture(TexFont * txf);

extern void txfBindFontTexture(TexFont * txf);

extern void txfUnloadFont(TexFont * txf);

extern void txfGetStringMetrics(TexFont * txf, char *string, int len, int *width, int *max_ascent, int *max_descent);

extern Float32 txfRenderGlyph(TexFont * txf, Int32 c, Float32 angle);

extern Float32 txfRenderGlyphSmooth(TexFont * txf, int c, UByte * col1, UByte * col2);

extern Float32 txfRenderString(TexFont * txf, char *string);

extern void txfRenderFancyString(TexFont * txf, char *string, int len);

extern int txfInFont(TexFont * txf, int c);


/************************************************************ End Prototypes */
/* end of automaticaly updated part */

#endif /* TEXFONT_H */
