#ifndef DWCHRONO_H
#define DWCHRONO_H


/* this part is automaticaly updated, do NOT edit below */
/**************************************************************** Prototypes */


/* DWReset
 *   Reset a chrono (set it to zero).
 * ct: chrono type (see DWChronoType) or 0 if you let it unchanged
 */
extern void DWChronoReset(DWChrono * pc, DWChronoType ct);

/* DWChronoCreate
 *   Create (and start) a new chrono.
 * ct: chrono type (see DWChronoType)
 * return: created chrono (think to free it later)
 */
extern DWChrono *DWChronoCreate(DWChronoType ct);

/* DWChronoPause
 *   Pause a chrono, ie: time stop to run till next Restart (or reset)
 * pc: chrono to be paused
 */
extern void DWChronoPause(DWChrono * pc);

/* DWChronoRestart
 *   Restart a previously paused chrono.
 * pc: chrono to be restarted
 */
extern void DWChronoRestart(DWChrono * pc);

/* DWChronoGet
 *   Get elapsed time since last reset
 * pc: chrono to read from
 * return: number of milliseconds elapsed.
 */
extern unsigned long DWChronoGet(DWChrono * pc);

/* DWMSPrint
 *   Print in a human readable format a milli second delay.
 *   (see also DWChronoPrint)
 * msec: delay to printA
 * str: if str is not NULL if will be filled else time will be printed by DWLPrintf
 * maxSize: size of str if not NULL
 * return:
 */
extern char *DWMSPrint(unsigned long msec, char *str, int maxSize);

/* DWChronoPrint
 *   Print a chrono in a human readable format.
 *   put human readable form in str assuming str is at least maxSize long
 *   if str is NULL (or maxSize == 0) print it on stdout instead of storing 
 *   it in str.
 * pc: chrono to print
 * str: where to put printed chorno
 * maxSize: size of str
 * return: str
 */
extern void DWChronoPrint(DWChrono * pc, char *str, int maxSize);


/************************************************************ End Prototypes */
/* end of automaticaly updated part */


#endif /* DWCHRONO_H */
