#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <string.h> 
#include <ctype.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <values.h>

#ifdef WIN32
#include <windows.h>
#endif

/* With cupdate script this is a clean way to generate a two level API (World/Lib).
 * Public  functions are prefixed by World, they are the real API -> darw.h
 * Private functions are prefixed by Lib, they are the internal lib API => darwP.h
 * Static  functions are prefixed by Module, scope reduced to module.
 */
#ifndef Lib
#define Lib
#endif
#ifndef World
#define World
#endif
#ifndef Module
#define Module static
#endif

/* the ultimate assert ;) */
#if DEBUG
#define UAssert(Test) \
 if(!(Test)) {DWMPrintf(DW_MPAlways,"%s:%d %s() assertion failed (%s)\n",__FILE__,__LINE__,__FUNCTION__,__STRING(Test)); dbgStopHere();};
#else /* DEBUG */
#define UAssert(Test)
#endif /* DW_DEBUG */

/*
 * Useful types
 */
typedef unsigned char UBool;
typedef unsigned char UByte;
/* system dependant (may need some fix to fit real world) */
typedef short Int16;
typedef int Int32;
typedef long Int64;
typedef unsigned short UInt16;
typedef unsigned int UInt32;
typedef unsigned long UInt64;
typedef float Float32;
typedef double Float64;

/*
 * Useful defines
 */
#define UTrue 1
#define UFalse 0

/*
 * Useful macros
 */
#define UFree(_P)        free(_P)
#define UFreeZ(_P)       if((_P)!=NULL){free(_P);_P=NULL;}
#define UMalloc(_S)      malloc(_S)
#define UMallocZ(_S)     calloc(1,_S)
#define UMallocF(_P,_S)  ((_P)?UFree(_P),UMalloc(_S):UMalloc(_S))
#define UMallocFZ(_P,_S) ((_P)?UFree(_P),UMallocZ(_S):UMallocZ(_S))
#define URealloc(_P,_S)  realloc(_P,_S)
#define UNew(_Type)      ((_Type*) UMalloc(sizeof(_Type)))
#define UNewZ(_Type)     ((_Type*) UMallocZ(sizeof(_Type)))
#define URand1()         (drand48())
#define UNYI             fprintf(stderr,"Not Yet Implemented!");exit(1)

#ifndef Min
#define Min(_A, _B)      (((_A) > (_B))?(_B) : (_A))
#endif
#ifndef Max
#define Max(_A, _B)      (((_A) < (_B))?(_B) : (_A))
#endif
#ifndef Abs
#define Abs(_A)          (((_A) >= 0) ? (_A) : -(_A))
#endif
#ifndef Bound
#define Bound(_MIN, _MAX, _V) (Max((_MIN), Min((_MAX), (_V))))
#endif


/*
 * 2D/3D data types and accessors 
 *
 * Conventions: O as argument means array is modified 
 */
#define Pi       M_PI
#define Pi_2     M_PI_2
#define Pi_4     M_PI_4
#define Deg(_R)  (_R*(180/Pi))
#define Rad(_D)  (_D*(Pi/180))
#define Sqrt2    1.41421356237309504880
#define Sqrt3    1.7320508
#define CosPi_6  .5
#define SinPi_6  (Sqrt3/2.)
#define CosPi_4  (Sqrt2/2.)
#define SinPi_4  (Sqrt2/2.)
#define CosPi_3  (Sqrt3/2.)
#define SinPi_3  .5


typedef float A4D[4];		/* rgba colors or 4d xyzw vectors */
typedef float A3D[3];		/* 3d coords or vectors */
typedef float A2D[2];		/* 2d coords or vectors */
typedef float A1D[1];		/* 1d for API covenience */
#define X(_A)       ((_A)[0])
#define Y(_A)       ((_A)[1])
#define Z(_A)       ((_A)[2])
#define W(_A)       ((_A)[3])
#define R(_A)       (X(_A))
#define G(_A)       (Y(_A))
#define B(_A)       (Z(_A))
#define A(_A)       (W(_A))
#define A1DSet(_O,_X)          (X(_O)=(_X))
#define A2DSet(_O,_X,_Y)       (X(_O)=(_X),Y(_O)=(_Y))
#define A3DSet(_O,_X,_Y,_Z)    (X(_O)=(_X),Y(_O)=(_Y),Z(_O)=(_Z))
#define A4DSet(_O,_X,_Y,_Z,_W) (X(_O)=(_X),Y(_O)=(_Y),Z(_O)=(_Z),W(_O)=(_W))

#define A1DGet(_O)      X(_O)
#define A2DGet(_O)      X(_O),Y(_O)
#define A3DGet(_O)      X(_O),Y(_O),Z(_O)
#define A4DGet(_O)      X(_O),Y(_O),Z(_O),W(_O)

#define A1DPrint(_A)    printf("(%g)",X(_A));fflush(stdout)
#define A2DPrint(_A)    printf("(%g, %g)",X(_A),Y(_A));fflush(stdout)
#define A3DPrint(_A)    printf("(%g, %g, %g)",X(_A),Y(_A),Z(_A));fflush(stdout)
#define A4DPrint(_A)    printf("(%g, %g, %g, %g)",X(_A),Y(_A),Z(_A),W(_A));fflush(stdout)

#define A2DMult(_O,_M)  X(_O)*=(_M),Y(_O)*=(_M)
#define A3DMult(_O,_M)  X(_O)*=(_M);Y(_O)*=(_M);Z(_O)*=(_M)
#define A4DMult(_O,_M)  X(_O)*=(_M),Y(_O)*=(_M),Z(_O)*=(_M),W(_O)*=(_M)

#define A2DAdd(_O,_I)   X(_O)+=(_I),Y(_O)+=(_I)
#define A3DAdd(_O,_I)   X(_O)+=(_I),Y(_O)+=(_I),Z(_O)+=(_I)
#define A4DAdd(_O,_I)   X(_O)+=(_I),Y(_O)+=(_I),Z(_O)+=(_I),W(_O)+=(_I)

#define A2DAddA2D(_O,_A)  X(_O)+=X(_A),Y(_O)+=Y(_A)
#define A3DAddA3D(_O,_A)  X(_O)+=X(_A),Y(_O)+=Y(_A),Z(_O)+=Z(_A)
#define A4DAddA4D(_O,_A)  X(_O)+=X(_A),Y(_O)+=Y(_A),Z(_O)+=Z(_A),W(_O)+=W(_A)

#define A2DAdd2(_O,_X,_Y)       X(_O)+=_X,Y(_O)+=_Y
#define A3DAdd3(_O,_X,_Y,_Z)    X(_O)+=_X,Y(_O)+=_Y,Z(_O)+=_Z
#define A4DAdd4(_O,_X,_Y,_Z,_W) X(_O)+=_X,Y(_O)+=_Y,Z(_O)+=_Z,W(_O)+=_W

#define A2DCp(S,_O) (X(_O)=X(S),Y(_O)=Y(S))
#define A3DCp(S,_O) (X(_O)=X(S),Y(_O)=Y(S),Z(_O)=Z(S))
#define A4DCp(S,_O) (X(_O)=X(S),Y(_O)=Y(S),Z(_O)=Z(S),W(_O)=W(S))

#define A1DZeroP(_A) ((_A[0]==0))
#define A2DZeroP(_A) ((_A[0]==0)&&(_A[1]==0))
#define A3DZeroP(_A) ((_A[0]==0)&&(_A[1]==0)&&(_A[2]==0))
#define A4DZeroP(_A) ((_A[0]==0)&&(_A[1]==0)&&(_A[2]==0)&&(_A[3]==0))

#define A1DZero(_O) (X(_O)=.0)
#define A2DZero(_O) (X(_O)=.0,Y(_O)=.0)
#define A3DZero(_O) (X(_O)=.0,Y(_O)=.0,Z(_O)=.0)
#define A4DZero(_O) (X(_O)=.0,Y(_O)=.0,Z(_O)=.0,W(_O)=0)


#define A1DInterp(_A,_B,_P,_O) \
  X(_O)=(_P)*X(_A)+(1-(_P))*X(_B)
#define A2DInterp(_A,_B,_P,_O) \
  X(_O)=(_P)*X(_A)+(1-(_P))*X(_B), \
  Y(_O)=(_P)*Y(_A)+(1-(_P))*Y(_B)
#define A3DInterp(_A,_B,_P,_O) \
  X(_O)=(_P)*X(_A)+(1-(_P))*X(_B), \
  Y(_O)=(_P)*Y(_A)+(1-(_P))*Y(_B), \
  Z(_O)=(_P)*Z(_A)+(1-(_P))*Z(_B)
#define A4DInterp(_A,_B,_P,_O) \
  X(_O)=(_P)*X(_A)+(1-(_P))*X(_B), \
  Y(_O)=(_P)*Y(_A)+(1-(_P))*Y(_B), \
  Z(_O)=(_P)*Z(_A)+(1-(_P))*Z(_B), \
  W(_O)=(_P)*W(_A)+(1-(_P))*W(_B)


#define A3DRandXYZ(_O,_XR,_YR,_ZR) \
                   ((X(_O)+=_XR*URand1()),(Y(_O)+=_YR*URand1()),(Z(_O)+=_ZR*URand1()))
#define A3DRandXY(_O,_XR,_YR) \
                   ((X(_O)+=_XR*URand1()),(Y(_O)+=_YR*URand1()))
#define A3DRandXZ(_O,_XR,_ZR) \
                   ((X(_O)+=_XR*URand1()),(Z(_O)+=_ZR*URand1()))
#define A3DRandYZ(_O,_YR,_ZR) \
                   ((Y(_O)+=_YR*URand1()),(Z(_O)+=_ZR*URand1()))
#define A3DRandX(_O,_XR) \
                   ((X(_O)+=_XR*URand1()))
#define A3DRandY(_O,_YR) \
                   ((Y(_O)+=_YR*URand1()))
#define A3DRandZ(_O,_ZR) \
                   ((Z(_O)+=_ZR*URand1()))
#define A3DRandXYZ(_O,_XR,_YR,_ZR) \
                   ((X(_O)+=_XR*URand1()),(Y(_O)+=_YR*URand1()),(Z(_O)+=_ZR*URand1()))

#define A3DRotZPC(_A,_Cos,_Sin,_O) (X(_O)=X(_A)*_Cos-Y(_A)*_Sin,Y(_O)=X(_A)*_Sin+Y(_A)*_Cos,Z(_O)=Z(_A))

/* BEWARE:
 * these 2 macros can't be used like A3DDotProd(A,B,A)
 * because A.x is modified prior to reuse.
 * A3DDotProd(A,B,C); A3DCp(C,A); is ok
 */
#define A3DDotProd(_A,_B,_O)   (X(_O)=X(_A)*X(_B),Y(_O)=Y(_A)*Y(_B),Z(_O)=X(_A)*X(_B))
#define A3DCrossProd(_A,_B,_O) (X(_O)=Y(_A)*Z(_B)-Z(_A)*Y(_B),Y(_O)=X(_A)*Z(_B)-Z(_A)*X(_B),Z(_O)=X(_A)*Y(_B)-Y(_A)*X(_B))

/* Normalization */
#define A3DSqrNorm(_O)    (X(_O)*X(_O)+Y(_O)*Y(_O)+Z(_O)*Z(_O))
#define A3DNorm(_O)       (sqrt(A3DSqrNorm(_O)))
#define A3DNormalize(_O)  { Float32 _n; _n=A3DNorm(_O); _n=1./_n;A3DMult(_O,_n);}
#define A3DNormCrossProd(_A,_B,_O) A3DCrossProd(_A,_B,_O);A3DNormalize(_O)


/* convert sperical to cartesian cordinates
 * _S is rho theta phi
 * _O is set to corresponding x y z
 */
#define SpherToCart(_S,_O) \
  X(_O) = _S[0] * cos(_S[2]) * cos(_S[1]);\
  Y(_O) = _S[0] * cos(_S[2]) * sin(_S[1]);\
  Z(_O) = _S[0] * sin(_S[2])

typedef Float64 Matd44[16];

/* compatibility with DW lib */
#define DWBool UBool
#define DWAssert UAssert
#define DWTrue UTrue
#define DWFalse UFalse
#define DWNew UNew
#define DWNYI UNYI

/* types of chrono */
typedef enum DWChronoType {
  DWChronoBad = 0, DWChronoReal, DWChronoUser, DWChronoSys
} DWChronoType;

/* a chrono or what else? */
typedef struct DWChrono {
  DWChronoType ct;
  unsigned long cumulative;
  DWBool paused;
  struct timeval start;
} DWChrono;

