#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */




/********************************************/
/* a very frequently used list: string list */

LString *
lsAdd(LString * ls, char *s)
{
    LString *ps;

    if (s == NULL)
	return ls;
    ps = (LString *) UMalloc(sizeof(LString));
    ps->next = ls;
    ps->s = s;
    return ps;
}

Bools
lsIn(LString * ls, char *s)
{
    while (ls) {
	if (!strcmp(ls->s, s))
	    return True;
	ls = ls->next;
    }
    return False;
}

void
lsFree(LString * ls, unsigned char freeElt)
{
    LString *ps;

    while (ls != NULL) {
	if (freeElt)
	    free(ls->s);
	ps = ls->next;
	free(ls);
	ls = ps;
    }
}
