#ifndef SLIST_H
#define SLIST_H


/* List */

typedef struct ListElt {
    void *pe;
    int flag;
    struct ListElt *next;
}       ListElt;

typedef struct List {
    int number;				/* a kind of id... useful for debug */
    int nbe;				/* NumBer of Elements */
    Bools modified;			/* for acces optimization */
    int lastN;				/* ie */
    ListElt *lastAns;			/* ie */
    void *(*keyFunc) ();		/* to extract key from element */
    int (*ordFunc) ();			/* to order keys  */
    void (*freeFunc) ();		/* to free user element */
    void (*printFunc) ();		/* to print user element */
    ListElt *pFirst;			/* list head (first element) */
    ListElt *pLast;			/* last element */
}

     List;

/**************************************************************** Prototypes */


/* Create a new list
 */
List *
     lCreate(void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (), void (*printFunc) ());

/* Free a list
 */
void
     lFree(List * pl, Bools freeElt);

/* Add pe in first place of list pl.
 */
void
     lAdd(List * pl, void *pe);

/* Add pe in first place of list pl
 * but only if pe is not already present (tested with ordFunc)
 */
void
     lAddUnique(List * pl, void *pe);

/* Add pe in last place of list pl
 */
void
     lAddLast(List * pl, void *pe);

/* ODOT...
 */
int
    lNbElts(List * pl);

/* List is not modified (first element is 0th)
 * Access is optimized to be in constant time (only if elements are accessed in
 * growing order).
 * So this function is usable in a loop to get each element of a list.
 *
 * Return: the nth element of list pl.
 *
 * Example: nbe=lNbElts(pl);
 *     for(i=0;i<nbe;i++)
 *        doSomething(lLookNth(pl,i));
 */
void *
lLookNth(List * pl, int n);

/* Extract first element form list pl which match with key pk
 */
void
lDelKey(List * pl, void *pk, Bools freeElt);

/* Extract first occurence of element pe form list pl
 */
void
lDel(List * pl, void *pe, Bools freeElt);

/* Does pl contain at least one element matching with key pk ?
 */
Bools
lInKey(List * pl, void *pk);

/* Does pl contain at least one element matching with element pe ?
 */
Bools
lIn(List * pl, void *pe);

/* Return: First element in pl matching key pk.
 */
void *
     lLookKey(List * pl, void *pk);

/* Return: First element in pl matching with element pe.
 */
void *
     lLook(List * pl, void *pe);

/* Cut and return head of list pl.
 */
void *
     lGetHead(List * pl);

/* Return: return (but don't remove) head of list pl.
 */
void *
     lLookHead(List * pl);

/* Mark this element (pe) as to be sweeped by next call to lSweep(pl).
 */
void
     lMarkToSweep(List * pl, void *pe);

/* must the element be freed?
					 * (calling the freeElt function
           given at list creation) */
int
    lSweep(List * pl, Bools freeElt);

/* Reverse list in place.
 */
void
     lReverse(List * pl);

/* Print list using the print function given at pl creatin.
 *
 * Useful for debuging.
 */
void
     lPrint(List * pl);

/************************************************************ End Prototypes */



#endif					/* SLIST_H */
