#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */



/*****************************************************************************\
*                                                                             *
* Growing Arrays                                                              *
*                                                                             *
\*****************************************************************************/

/* ODOT...
 */
GArray *
gaCreate(void (*printFunc) ())
{
    static number = 0;
    GArray *pga;

    pga = UNew(GArray);
    pga->number = number++;
    pga->nbe = 0;
    pga->sz = GARRAY_STARTSZ;
    pga->ea = (void **) UCalloc(pga->sz, sizeof(void *));

    pga->printFunc = printFunc;
    return pga;
}

/* ODOT...
 */
void
gaFree(GArray * pga)
{
    free(pga->ea);
    free(pga);
}

/* ODOT...
 */
void
gaPrint(GArray * pga)
{
    int i, nbe;

    nbe = pga->nbe;
    printf("GArray (%d): |", pga->number);
    for (i = 0; i < nbe; i++) {
	if (pga->ea[i]) {
	    pga->printFunc(pga->ea[i]);
	}
	else
	    printf("NULL");
	printf("|");
    }
}

/* Add element in first free position.
 *
 * Array grows if needed.
 *
 * Return: this position number.
 *
 * Warning: adding NULL elements may lead to conflicts.
 */
int
gaAdd(GArray * pga, void *pe)
{
    int i = 0;

    while ((i < pga->sz) && (pga->ea[i]))
	i++;

    if (i == pga->sz) {			/* no room left -> grow array */
	pga->sz = (float) pga->sz * GARRAY_MULTSZ + 1;
	pga->ea = (void **) UReallocMsg(pga->ea, pga->sz * sizeof(void *), "GArray can't grow");
    }
    pga->ea[i] = pe;
    pga->nbe++;
    return i;
}

/* Remove nth element from this array (this position is then free).
 * if not NULL freefunc is used to free non NULL elements.
 */
void
gaDelNth(GArray * pga, int nb, void (*freeFunc) ())
{
    if (pga->ea[nb]) {
	if (freeFunc)
	    (*freeFunc) (pga->ea[nb]);
	pga->ea[nb] = NULL;
	pga->nbe--;
    }
}

/* Return: return (but doesn't remove) nth element of this array.
 */
void *
gaLookNth(GArray * pga, int nb)
{
    if (nb < pga->sz)
	return pga->ea[nb];
    else
	return NULL;
}

/* Number of non NULL elements in this array.
 */
int
gaNbElts(GArray * pga)
{
    return pga->nbe;
}

/* Number of cells in this array (some may be empty).
 */
int
gaSize(GArray * pga)
{
    return pga->sz;
}
