#ifndef SCOMM_H
#define SCOMM_H

/* must rebuil external fd_set? useful for selects...
 * each connect deconect increment it by one
 */
extern int USMustRebuildFDSet;


/**************************************************************** Prototypes */


/* Init the server.
 *
 * Must be called before any call to other function of this lib.
 *
 * Return: 0 or error code
 *
 * Warning: this function set the signal handler for SIG_PIPE to SIG_IGN
 */
int USInit ( int portNum, char *serverName );

/* Close the line (id).
 *
 * Return: 0 or error code
 */
int USCloseLine ( int id );

/* Check if new applications are requesting for lines.
 *
 * Accept the first one and put it's id in pId.
 * Use pGetLine (if non NULL) to return if got Line (0 or 1)
 * (must be called until *pGetLine is 0).
 *
 * Return: 0 or error code
 *
 * Warning: this function must be called periodicaly to insure that connection
 * requests aren't ignored
 */
int USAcceptNewLine ( int *pId, int *pGotLine );

/* Wait for a new application.
 *
 * Accept it and put it's id in pId.
 *
 * Warning: this function may block.
 */
int USWaitForNewLine ( int *pId );

/* Lenght of data to send */
int USSend ( int id, void *msg, int len );

/* Send all messages which may have been buffered (if any)
 * (ie flush actual packet (if needed)).
 *
 * Return: 0 or error code
 */
int USFlush ( int id );

/* Flush messages waiting to be send for all clients
 */
int USFlushAllClients ( void );

/* How many messages are waiting for a read.
 *
 * Return imediatly if messages are already queued.
 * If no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer).
 *
 * Warning: function may block a bit if correspondant is too busy.
 */
int USPendingMsg ( int id, int *pNbMsg );

/* How many messages are waiting for a read.
 *
 * Checks for waiting packets and return
 * nether blocks
 */
int USCheckPendingMsg ( int id, int *pNbMsg );

/* Checks if there is something waiting for a read on all connected lines
 *
 * Do the check as fast as possible (only one select)
 * nether blocks
 */
int USCheckAllLines ( int *pIsMsg );

/* Fill a fd_set (eg: for a select) with sockets fd of all limes connected
 * to the server.
 *
 * Return: max fd stored in *pFdSet
 */
int USFillFdAllLines ( fd_set * pFdSet );

/* Lenght of returned message */
int USGetNextMsg ( int id, char **ppMsg, int *pLen );

/* Lenght of returned message */
int USPeekNextMsg ( int id, char **ppMsg, int *pLen );

/* String which must be the head of
		          matching message */
int USGetFirstMatchingMsg ( int id, char *head, char **ppMsg, int *pLen );

/* String which must be the head of
		           matching message */
int USPeekFirstMatchingMsg ( int id, char *head, char **ppMsg, int *pLen );

/* Return id associated to line nammed (lineName)
 * or -1 if no such line
 */
int USNameToId ( char *lineName );

/* Return name of line identified by id
 * or NULL if no such line
 *
 * Warning: Caller is responsible for freeing the returned string
 */
char * USIdToName ( int id );

/* Checks if this name may be given to this line.
 *
 * Actually just checks if it has not been set for another line.
 *
 * Return: False on problem or True if it's ok.
 *
 * Warning: runs only on server side.
 */
Bools USCheckForGoodName ( char *name );

/* Convert an error code to a string.
 *
 * CWarning: Caller is responsible for freeing the returned string.
 */
char * USErrCodeToErrString ( int errCode );

/************************************************************ End Prototypes */


#endif					/* SCOMM_H */
