#include <math.h>

#include "util.h"

/**************************************************************** Prototypes */


/******************************************************************** Bodies */

/* ODOT...
 */
double
norm2D(v2D * pv)
{
    return sqrt((pv->x) * (pv->x) + (pv->y) * (pv->y));
}

/* ODOT...
 */
v2D
p2v2D(p2D * pa, p2D * pb)
{
    v2D v;

    v.x = (pb->x - pa->x);
    v.y = (pb->y - pa->y);
    return v;
}

/* ODOT...
 */
double
crossProd2D(v2D * pu, v2D * pv)
{
    return (pu->x * pv->x) + (pv->y * pu->y);
}

/* ODOT...
 */
v2D
normalized2D(v2D * pv)
{
    v2D u;
    double normv;

    normv = norm2D(pv);
    u.x = pv->x / normv;
    u.y = pv->y / normv;
    return u;
}

/* ODOT...
 */
void
normalize2D(v2D * pv)
{
    double normv;

    normv = norm2D(pv);
    pv->x = pv->x / normv;
    pv->y = pv->y / normv;
}

/* ODOT...
 */
v2D
add2D(v2D * p1, v2D * p2)
{
    v2D a;

    a.x = p1->x + p2->x;
    a.y = p1->y + p2->y;
    return a;
}

/* ODOT...
 */
v2D
mul2D(double k, v2D * p1)
{
    v2D a;

    a.x = k * (p1->x);
    a.y = k * (p1->y);
    return a;
}

/* ODOT...
 */
v2D
interp2D(double k1, double k2, v2D * p1, v2D * p2)
{
    v2D a;

    a.x = k1 * (p1->x) + k2 * (p2->x);
    a.y = k1 * (p1->y) + k2 * (p2->y);
    return a;
}
