#include <stdio.h>
#include <varargs.h>



/*
 * internalError should be called like:
 *    internalError(function_name, format, arg1, arg2...);
 *    the format string is like this used by printf
 *    ex:
 *         internalError("malloc", "can't allocate %d bytes, %d allocated"
 *                       ,size, allocatedSize);
 */
void
internalError(va_alist)
va_dcl
{
    va_list args;
    char *fmt;

    va_start(args);
    /* print name of function causing error */
    (void) fprintf(stderr, "Internal ERROR in %s: ", va_arg(args, char *));
    fmt = va_arg(args, char *);
    /* print out remainder of message */
    (void) vfprintf(stderr, fmt, args);
    va_end(args);
}



/*
 * used as an easier way to fill a set of variables with contents of a variable
 * lenght list of parameters
 *      apf: format string describing the type of the variable list of
 *           parameters
 *           d (int)
 *           f (double)
 *           p (void *)
 *           "ddfp" -> two 'ints' a 'double' and a 'pointer'
 *      lpv: va_list containing the src values
 *      va_alist : list of dest variables adress
 *
 * ex:
 *
 * vaParmtest(va_alist)
 *     va_dcl
 * {
 *     va_list lp;
 *     int i1,i2;
 *     double d1,d2;
 *     char * ac;
 *
 *     va_start (lp);
 *     vaParmFill("dffdp",&lp,&i1,&d1,&d2,&i2,&ac);
 *     printf("%d %f %f %d %s\n",i1,d1,d2,i2,ac);
 *     va_end(lp);
 * }
 *
 * main()
 * {
 *     vaParmtest(10,1.0,2.0,20,"blabla-hello");
 * }
 */
int
vaParmFill(apf, lpv, va_alist)
    char *apf;
    va_list *lpv;

va_dcl
{
    va_list lpd;
    void *pd;
    char *spec;

    va_start(lpd);
    spec = apf;
    while (*spec) {
	pd = (void *) va_arg(lpd, void *);
	switch (*spec) {
	case 'd':{
		(*(int *) pd) = va_arg(*lpv, int);
		break;
	    }
	case 'f':{
		(*(double *) pd) = va_arg(*lpv, double);
		break;
	    }
	case 'p':{
		(*(void **) pd) = va_arg(*lpv, void *);
		break;
	    }
	default:{
		internalError("vaParmFill", "in format >%s< bad spec >%c<\n", apf, *spec);
	    }
	}
	spec++;
    }
    va_end(lpd);
}
