#include <stdio.h>
#include "util.h"


#define UCOMM_CHECK_ERR(s) {int UCOMM_stat; if((UCOMM_stat=(s))){fprintf(stderr,"ServerError:%s\n",UErrCodeToErrString(UCOMM_stat)); exit(UCOMM_stat);}}

int port, dummy, msgLen;
int aid[100], nid;
int nbid = 0;

void
fillCaller()
{
    int gotLine;

    do {
	UCOMM_CHECK_ERR(USAcceptNewLine(&nid, &gotLine));
	if (gotLine) {
	    printf("|");
	    fflush(stdout);
	    aid[nbid++] = nid;
	}
    } while (gotLine);
}

int
main(int argc, char **argv)
{
    int i, nbm,l,ln,n,c;
    char *pMsg;
    Chrono * pc;
    long tl=0,dt;

    if (argc < 2)
	port = 6005;
    else
	port = atoi(argv[1]);
    
    UCOMM_CHECK_ERR(USInit(port, "serverTest"));
    while (!nbid) {
	fillCaller();
	printf(".");
	fflush(stdout);
	sleep(1);
    }
    ln=0;
    pc=UChronoCreate();
    while (1) {
	for (i = 0; i < nbid; i++) {
	    UCOMM_CHECK_ERR(USCheckPendingMsg(aid[i], &nbm));
	    while (nbm--) {
		UCOMM_CHECK_ERR(USGetNextMsg(aid[i], &pMsg, &msgLen));
                tl+=msgLen;
                if(c++==1000){
                    dt=UChronoGet(pc);
                    printf("%d b/s (%d bytes in %d millisec)\n",(tl/dt)*1000,tl,dt);
                    c=0;
                }
		UFree(pMsg);
	    }
	}
	fillCaller();
	fflush(stdout);
    }
}
