#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "util.h"

/**************************************************************** Prototypes */


/******************************************************************** Bodies */

/* */

/* ODOT...
 */
void
UGetSuffix(char *fileName, char *suffix)
{
    char *pSep;

    *suffix = '\0';
    pSep = strrchr(fileName, '.');
    if (pSep)
	strcpy(suffix, pSep + 1);
    else
	*suffix = '\0';
}

/* ODOT...
 */
void
UExtractSuffix(char *fileName, char *suffix)
{
    int sl, fl;

    fl = strlen(fileName);
    sl = strlen(suffix);
    if (!strcmp(fileName + (fl - sl), suffix)) {
	*(fileName + (fl - sl)) = '\0';
    }
    else {
	UIWarning("UExtractSuffix", "suffix >%s< don't match with >%s< !", suffix, fileName);
    }
}

/* ODOT...
 */
void
UAddSuffix(char *fileName, char *suffix)
{
    strcat(fileName, ".");
    strcat(fileName, suffix);
}

/* Get some string parameter out of argv
 * return : * OK  or Err
 */
int
getStringParam(int *pargc /* pointer on argc */ ,
	       char ***pargv /* pointer on argv */ ,
	       char **string		/* if success allocated and filled
					 * with the parameter argc and argv
					 * are modified due to the match
	           found */ )
{
    if ((**pargv)[2] != '\0') {		/* like -sname */
	*string = (char *) UMalloc(sizeof(char) * (1 + strlen(&((**pargv)[2])))
	);

	strcpy(*string, &((**pargv)[2]));
	(*pargv)++;			/* forget the '-sname' */
	(*pargc)--;
	return Ok;
    }
    else {				/* like -s name */
	(*pargv)++;			/* forget the '-s' */
	(*pargc)--;
	if (*pargc <= 0)
	    return Err;
	if ((**pargv)[0] != '-') {
	    *string = (char *) UMalloc(sizeof(char) * (1 + strlen(**pargv)));

	    strcpy(*string, **pargv);
	    (*pargv)++;			/* forget the 'name' */
	    (*pargc)--;
	    return Ok;
	}
	else {
	    return Err;
	}
    }
}


/* Print (s) but show all non ascii characters using \ and their ascii values
 */
void
UPrintAll(char *s)
{
    if (!s)
	return;
    while (*s) {
	if ((isgraph(*s)) || (*s = ' '))
	    putchar(*s);
	else
	    printf("\\%d", *s);
	s++;
    }
}
