#ifndef STREE_H
#define STREE_H


/* Tree */

typedef struct TreeNode {
    void *pe;				/* pointer on a user-element */
    int flag;
    int nbs;				/* NumBer of Sons */
    struct TreeNode **sa;		/* Sons Array */
    struct Tree *pt;			/* for easy acces to generic
					 * functions */
}        TreeNode;

typedef struct Tree {
    int nbn;				/* NumBer of Nodes */
    void *(*keyFunc) ();		/* to extract key from element */
    int (*ordFunc) ();			/* to order keys  */
    void (*freeFunc) ();		/* to free user element */
    void (*printFunc) ();		/* to print user element */
    TreeNode *root;			/* tree root */
}

     Tree;


/**************************************************************** Prototypes */


/* ODOT...
 */
Tree *
     tCreate(void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (), void (*printFunc) ());

/* ODOT...
 */
void
     tFree(Tree * pt, Bools freeElt);

/* ODOT...
 */
TreeNode *
         tAddNode(Tree * pt, TreeNode * ptnf, void *pe);

/* ODOT...
 */
int
    tNbSons(TreeNode * ptn);

/* ODOT...
 */
List *
     tBreadthFirst(Tree * pt);

/* ODOT...
 */
List *
     tDephtFirst(Tree * pt);

/* ODOT...
 */
void
     tPrint(Tree * pt);

/************************************************************ End Prototypes */



#endif					/* STREE_H */
