#ifndef SHASHT_H
#define SHASHT_H




/* Hash Table */

typedef struct HashList {
    void *pe;				/* pointer on a user-element */
    struct HashList *next;
}        HashList;

typedef struct HashListHeader {
    HashList *l;
    int lsz;
}

               HashListHeader;

typedef struct HashTable {
    int number;				/* a kind of id... useful for debug */
    int size;				/* hash table size */
    int nbe;				/* NumBer of Elements */
    Bools modified;			/* for acces optimization */
    int lastAskedn;			/* ie */
    int lastHTInd;			/* ie */
    int lastEltCount;			/* ie */
    void *(*keyFunc) ();		/* to extract key from element */
    int (*ordFunc) ();			/* to order keys  */
    void (*freeFunc) ();		/* to free user element */
    int (*hashFunc) ();			/* to hash key */
    void (*printFunc) ();		/* to print user element */
    HashListHeader *hla;		/* Hash List Array */
}

          HashTable;



/**************************************************************** Prototypes */


/* ODOT...
 */
HashTable *
          htCreate(int size, void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (), int (*hashFunc) (), void (*printFunc) ());

/* ODOT...
 */
void
     htFree(HashTable * pht, Bools freeElt);

/* ODOT...
 */
void
     htPrint(HashTable * pht);

/* ODOT...
 */
void *
     htSearch(HashTable * pht, void *pe);

/* ODOT...
 */
void *
     htSearchKey(HashTable * pht, void *key);

/* Se description section. */
void
     htInsert(HashTable * pht, void *pe, Bools freeElt);

/* ODOT...
 */
void
     htDelKey(HashTable * pht, void *key, Bools freeElt);

/* ODOT...
 */
void
     htDel(HashTable * pht, void *pe, Bools freeElt);

/* ODOT...
 */
int
    htNbElts(HashTable * pht);

/* Sequential access (like in loops) are specialy optimized to be in O(n)
 * and not in O(n2) (as far as you do it in increasing order)
 * first element is 0.
 *
 * Return: the nth element in hashtable.
 */
void *
     htLookNth(HashTable * pht, int n);

/************************************************************ End Prototypes */



#endif					/* SHASHT_H */
