#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <limits.h>

#include "util.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */



/*****************************************************************************\
*                                                                             *
* Hash Table                                                                  *
*                                                                             *
\*****************************************************************************/

/* */

/* ODOT...
 */
HashTable *
          htCreate(int size, void *(*keyFunc) (), int (*orderFunc) (), void (*freeFunc) (), int (*hashFunc) (),
		   void (*printFunc) ())
{
    HashTable *ht;
    static number = 1;

    if ((keyFunc == NULL) || (orderFunc == NULL) || (freeFunc == NULL) || (hashFunc == NULL) || (size <= 0))
	UIError("createHashTable", "bad parameters");
    ht = (HashTable *) UMallocMsg(sizeof(HashTable), "createHashTable: ");
    ht->size = size;
    ht->nbe = 0;
    ht->number = number++;
    ht->modified = True;
    ht->lastAskedn = -1;
    ht->lastHTInd = 0;
    ht->lastEltCount = 0;
    ht->hla = (HashListHeader *) UCallocMsg(size, sizeof(HashListHeader), "createHashTable: ");
    ht->keyFunc = keyFunc;
    ht->ordFunc = orderFunc;
    ht->freeFunc = freeFunc;
    ht->hashFunc = hashFunc;
    if (printFunc == NULL)
	printFunc = printVoid;
    ht->printFunc = printFunc;
    return ht;
}

/* ODOT...
 */
void
htFree(HashTable * pht, Bools freeElt)
{
    int i;
    HashList *hl, *hlb;

    for (i = 0; i < pht->size; i++) {
	hl = pht->hla[i].l;
	while (hl != NULL) {
	    if (freeElt)
		(*pht->freeFunc) (hl->pe);
	    hlb = hl;
	    hl = hl->next;
	    free(hlb);
	}
    }
    free(pht->hla);
    free(pht);
}

/* ODOT...
 */
void
htPrint(HashTable * pht)
{
    int nbelts, i;

    nbelts = htNbElts(pht);
    for (i = 0; i < nbelts; i++) {
	pht->printFunc(htLookNth(pht, i));
    }
    printf("\n");
}

/* ODOT...
 */
void *
htSearch(HashTable * pht, void *pe)
{
    void *k;

    k = (*pht->keyFunc) (pe);
    return htSearchKey(pht, k);
}

/* ODOT...
 */
void *
htSearchKey(HashTable * pht, void *key)
{
    int hind;
    HashList *hl;
    void *k1;

    hind = (*pht->hashFunc) (key, pht->size);
    hl = pht->hla[hind].l;
    while (hl != NULL) {
	k1 = (*(pht->keyFunc)) (hl->pe);
	if (((*pht->ordFunc) (k1, key)) == 0)
	    return hl->pe;
	hl = hl->next;
    }
    return NULL;
}

/* Insert element pointed by (pe) in hashtable (pht).
 *
 * If an element has the same key than pe it's replaced with pe.
 * In this case it's freed or not depending on Bools (freeElt)
 */
void
htInsert(HashTable * pht /* The hashtable */ ,
	 void *pe /* the pointed element */ ,
	 Bools freeElt /* Se description section. */ )
{
    int hind;
    HashList *hl;

    pht->modified = True;
    hind = (*pht->hashFunc) ((*pht->keyFunc) (pe), pht->size);
    if (htSearch(pht, pe) == NULL) {
	hl = (HashList *) UMallocMsg(sizeof(HashList), "htInsert: ");
	hl->pe = pe;
	hl->next = pht->hla[hind].l;
	pht->hla[hind].l = hl;
	pht->hla[hind].lsz++;
	pht->nbe++;
    }
    else {				/* ?? TODE: tobe optimized (modify
					 * structure in place) */
	htDel(pht, pe, freeElt);
	htInsert(pht, pe, freeElt);
    }
}

/* ODOT...
 */
void
htDelKey(HashTable * pht, void *key, Bools freeElt)
{
    int hind;
    HashList *hl, *hlp;
    void *k1;

    pht->modified = True;
    hind = (*pht->hashFunc) (key, pht->size);
    hl = pht->hla[hind].l;
    while (hl != NULL) {
	k1 = (*pht->keyFunc) (hl->pe);
	if (!(*pht->ordFunc) (k1, key)) {
	    if (hl == pht->hla[hind].l)
		pht->hla[hind].l = hl->next;
	    else
		hlp->next = hl->next;
	    if (freeElt)
		pht->freeFunc(hl->pe);
	    free(hl);
	    pht->hla[hind].lsz--;
	    return;
	}
	hlp = hl;
	hl = hl->next;
    }
}

/* ODOT...
 */
void
htDel(HashTable * pht, void *pe, Bools freeElt)
{
    void *k;

    k = (*pht->keyFunc) (pe);
    htDelKey(pht, k, freeElt);
}

/* ODOT...
 */
int
htNbElts(HashTable * pht)
{
    return pht->nbe;
}


/* Sequential access (like in loops) are specialy optimized to be in O(n)
 * and not in O(n2) (as far as you do it in increasing order)
 * first element is 0.
 *
 * Return: the nth element in hashtable.
 */
void *
htLookNth(HashTable * pht, int n)
{
    HashList *hl;
    int nbelt;
    int i;
    int htInd;


    if (n < 0)
	UIError("htLookNth", "bad element rank %d (<0)", n);
    if ((n >= pht->lastAskedn) && (pht->modified == False)) {
	nbelt = pht->lastEltCount;
	htInd = pht->lastHTInd;
    }
    else {
	nbelt = 0;
	htInd = 0;
    }
    pht->modified = False;
    pht->lastAskedn = n;
    n++;				/* simpler code if first element is 1
					 * instead of 0 */
    for (i = htInd; i < pht->size; i++) {
	if (nbelt + pht->hla[i].lsz >= n) {
	    hl = pht->hla[i].l;
	    pht->lastEltCount = nbelt;
	    while (nbelt < n - 1) {
		nbelt++;
		hl = hl->next;
	    }
	    pht->lastHTInd = i;
	    return hl->pe;
	}
	nbelt += pht->hla[i].lsz;
    }
    UIError("htLookNth", "no element of this rank %d", n);
    return NULL;			/* not reached */
}
