#ifndef SGROWA_H
#define SGROWA_H


/* Growing Array */

typedef struct GArray {
    int number;				/* a kind of id... useful for debug */
    int nbe;				/* number of elements of this array */
    int sz;				/* actual maximum size  " */
    void **ea;				/* the array */
    void (*printFunc) ();		/* to print user element */
}

       GArray;

/**************************************************************** Prototypes */


/* ODOT...
 */
GArray *
       gaCreate(void (*printFunc) ());

/* ODOT...
 */
void
     gaFree(GArray * pga);

/* ODOT...
 */
void
     gaPrint(GArray * pga);

/* Add element in first free position.
 *
 * Array grows if needed.
 *
 * Return: this position number.
 *
 * Warning: adding NULL elements may lead to conflicts.
 */
int
    gaAdd(GArray * pga, void *pe);

/* Remove nth element from this array (this position is then free).
 * if not NULL freefunc is used to free non NULL elements.
 */
void
     gaDelNth(GArray * pga, int nb, void (*freeFunc) ());

/* Return: return (but doesn't remove) nth element of this array.
 */
void *
     gaLookNth(GArray * pga, int nb);

/* Number of non NULL elements in this array.
 */
int
    gaNbElts(GArray * pga);

/* Number of cells in this array (some may be empty).
 */
int
    gaSize(GArray * pga);

/************************************************************ End Prototypes */



#endif					/* SGROWA_H */
