#ifndef COMMONMSG_H
#define COMMONMSG_H
#include <errno.h>

#include "util.h"

/* RETurn IF Non Zero or make core for debug */
#define URetIfNz(a) {int URETIF_status;if ((URETIF_status=(a))) return (URETIF_status==EPIPE)?UCOMM_ERR_DISCONNECTED:URETIF_status;}
/*#define URetIfNz(a) {int URETIF_status;if ((URETIF_status=(a))) {MAKECORE;return (URETIF_status==EPIPE)?UCOMM_ERR_DISCONNECTED:URETIF_status;}}*/


/* some predefined error */
#define UCOMM_ERR_GETHOSTBYNAME -100
#define UCOMM_ERR_CONNECT -101
#define UCOMM_ERR_DISCONNECTED -102
#define UCOMM_ERR_BADNAME -103

/* maximum size of packets emmited on lines */
#define UCOMM_PACKET_SIZE 1024

/* message types */
#define UCOMM_MSG_USER (Byte)1
#define UCOMM_MSG_REGISTERREQ (Byte)10
#define UCOMM_MSG_REGISTERACK (Byte)11
#define UCOMM_MSG_REGISTERBAD (Byte)12
#define UCOMM_MSG_FLUSHREQ (Byte)20
#define UCOMM_MSG_FLUSHACK (Byte)21

/* delay (in micro-seconds) of sleep in waiting-message-loops */
#define UCOMM_LOOP_DELAY 10

typedef struct RcvMsg {
    Byte msgType;
    int msgLen;
    char *pMsg;
}

       RcvMsg;

typedef struct ConnectionLine {
    char *lineName;			/* name of this connection line */
    int socketNum;			/* number of the socket to use for
					 * this line */
    List *lReceivedMsg;			/* list of messages received(waiting
					 * a read) */
    char packToSend[UCOMM_PACKET_SIZE];	/* array of bytes -> will become a
					 * packet */
    int packToSendLen;			/* number of bytes already in packet
					 * (waiting to be send) */
    int nbSendPacket;			/* number of packets send */
    int nbSendMsg;			/* number of messages send */
    int nbReceivedMsg;			/* number of messages received since
					 * line connection */
}

               ConnectionLine;


/**************************************************************** Prototypes */


/* Incorporate waiting packets.
 *
 * Read pending packets.
 * Answer to internal request messages (like FLUSHREQ).
 * Add remaining messages to the queue.
 * If last message is truncated wait until completion.
 *
 * Return: 0 or error code
 */
int
    UIncWaitingPacketsCommon(ConnectionLine * pConn);

/* Extract msg from a struct RcvMsg
 */
char *
     UKeyRcvMsg(RcvMsg * pm);

/* Free a struct RcvMsg
 */
void
     UFreeRcvMsg(RcvMsg * pm);

/* Print a struct RcvMsg (debug)
 */
void
     UPrintRcvMsg(RcvMsg * pm);

/* Print some info on this connectionLine
 * Useful for debug
 */
void
     UConnPrint(ConnectionLine * pConn);

/* Add a connectionLine (in a GArray of)
 */
int
    UAddAConn(ConnectionLine * pConn, GArray ** paConn);

/* Lenght of data to send */
int
    USendCommon(ConnectionLine * pConn, Byte msgType, void *msg, int len);

/* Send all messages which may have been buffered (if any)
 * (ie flush actual packet (if needed)).
 *
 * Return: 0 or error code
 */
int
    UFlushCommon(ConnectionLine * pConn);

/* How many messages are waiting for a read.
 *
 * Return imediatly if messages are already queued.
 * If no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer)
 *
 * Warning: May block a bit if correspondant is too busy.
 */
int
    UPendingMsgCommon(ConnectionLine * pConn, int *pNbMsg);

/* How many messages are waiting for a read.
 *
 * Checks for waiting packets and return
 * nether blocks
 */
int
    UCheckPendingMsgCommon(ConnectionLine * pConn, int *pNbMsg);

/* Checks if there is something waiting for a read on all connected lines.
 *
 * Do the check as fast as possible (only one select)
 * nether blocks
 */
int
    UCheckAllLinesCommon(GArray * aConn, int *pIsMsg);

/* Fill a fd_set (eg: for a select) with sockets fd of all limes stored
 * in aConn
 *
 * Return: max fd stored in *pFdSet
 */
int
    UFillFdAllLinesCommon(GArray * aConn, fd_set * pFdSet);

/* Lenght of returned message */
int
    UGetNextMsgCommon(ConnectionLine * pConn, char **ppMsg, int *pLen);

/* Lenght of returned message */
int
    UPeekNextMsgCommon(ConnectionLine * pConn, char **ppMsg, int *pLen);

/* String which must be the head of
			       matching message */
int
    UGetFirstMatchingMsgCommon(ConnectionLine * pConn, char *head, char **ppMsg, int *pLen);

/* String which must be the head of
			        matching message */
int
    UPeekFirstMatchingMsgCommon(ConnectionLine * pConn, char *head, char **ppMsg, int *pLen);

/* Return only if a message is received (or already queued).
 *
 * Flush if needed and ask periodicaly for other line-end flush until
 * message is received.
 *
 * Return: 0 or error code
 */
int
    UWaitForMsgCommon(ConnectionLine * pConn);

/* Return id associated to line nammed (lineName) in aConn
 * or -1 if no such line
 */
int
    UNameToIdCommon(char *lineName, GArray * aConn);

/* Return name of line identified by id in aConn
 * or NULL if no such line
 * caller is responsible for freeing the returned string
 */
char *
     UIdToNameCommon(int id, GArray * aConn);

/* Close a line in aConn.
 *
 * Remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 *
 * Warning: any pending message on this line will be lost
 */
int
    UCloseLineCommon(int id, GArray * aConn);

/* Close all lines in aConn.
 *
 * Remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 */
int
    UCloseAllLinesCommon(GArray * aConn);

/* Convert an error code to a string.
 *
 * Caller is responsible for freeing the returned string
 */
char *
     UErrCodeToErrString(int errCode);

/* Register name for this line (only for apps).
 *
 * Return: 0 or error code (UCOMM_ERR_BADNAME for a bad name)
 */
int
    URegisterNameAppSide(int id, GArray * aConn, char *lineName);

/************************************************************ End Prototypes */


#endif					/* COMMONMSG_H */
