#ifndef ALLOC_H
#define ALLOC_H

#define UZalloc(s) UCalloc(1,(s));
#define UZallocMsg(s,msg) UCallocMsg(1,(s),(msg));

/**************************************************************** Prototypes */


/* Like the standard strdup function.
 *
 * Avantages on the stadard strdup function;
 * Don't crash if (s) is NULL (return NULL).
 * Test if allocation is succesful (if not generate an error message).
 */
char *
     UStrDup(char *s);

/* Like the standard malloc function.
 *
 * Avantages on the standard malloc function;
 * Test if allocation is succesful (if not generate an error message).
 */
void *
     UMalloc(size_t s);

/* Printed message if allocation
	       fails */
void *
     UMallocMsg(size_t s, char *msg);

/* Like the standard realloc function.
 *
 * Avantages on the standard realloc function;
 * Test if old pointer is null (if it's the case make an alloc instead of a
 * realloc).
 * Test if allocation is succesful (if not generate an error message)
 */
void *
     URealloc(void *oldPt, size_t s);

/* Printed message if allocation
	        fails */
void *
     UReallocMsg(void *oldPt, size_t s, char *msg);

/* Like the standard calloc function
 *
 * Avantages on the standard realloc function;
 * Test if allocation is succesful (if not generate an error message)
 */
void *
     UCalloc(int nbElt, int eltSz);

/* Printed message if allocation
	       fails */
void *
     UCallocMsg(int nbElt, int eltSz, char *msg);

/* Like the standard free function.
 *
 * Avantages on the standard realloc function;
 * Check if non NULL pointer
 */
void
     UFree(void *p);

/************************************************************ End Prototypes */


#endif					/* ALLOC_H */
