#ifndef ACOMM_H
#define ACOMM_H

/**************************************************************** Prototypes */


/* Opens a line of connection from this application to a server.
 *
 * The server is defined by it's address and a port number.
 * An id is returned which identify this line. So message communications on
 * this line must use this id.
 * If a less crude identification is needed by server this line may be named
 * (with a string). Use URegisterName to do so.
 *
 * Return: 0 or an error code
 *
 * Warning: this function set the signal handler for SIG_PIPE to SIG_IGN
 */
int
    UAOpenLine(char *serverAdress, int portNum, int *pId);

/* Register name for this line.
 *
 * Return: 0 or error code (UCOMM_ERR_BADNAME for a bad name)
 */
int
    UARegisterName(int id, char *lineName);

/* Close a line.
 *
 * Remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 *
 * Warning: any pending message on this line will be lost
 */
int
    UACloseLine(int id);

/* Close all lines.
 *
 * Remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 */
int
    UACloseAllLines(void);

/* Lenght of data to send */
int
    UASend(int id, void *msg, int len);

/* Send all messages which may have been buffered (if any)
 * (ie flush actual packet (if needed))
 *
 * Return: 0 or error code
 */
int
    UAFlush(int id);

/* How many messages are waiting for a read.
 *
 * Return imediatly if messages are already queued.
 * If no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer).
 *
 * Warning: so may block a bit if correspondant is too busy.
 */
int
    UAPendingMsg(int id, int *pNbMsg);

/* How many messages are waiting for a read.
 *
 * Checks for waiting packets abd return
 * nether blocks
 */
int
    UACheckPendingMsg(int id, int *pNbMsg);

/* Checks if there is something waiting for a read on all connected lines.
 *
 * Do the check as fast as possible (only one select)
 * nether blocks
 */
int
    UACheckAllLines(int *pIsMsg);

/* Lenght of returned message. */
int
    UAGetNextMsg(int id, char **ppMsg, int *pLen);

/* Lenght of returned message */
int
    UAPeekNextMsg(int id, char **ppMsg, int *pLen);

/* String which must be the head of
		          matching message */
int
    UAGetFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);

/* String which must be the head of
		           matching message */
int
    UAPeekFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);

/* Return id associated to line nammed (lineName)reg
 * or -1 if no such line
 */
int
    UANameToId(char *lineName);

/* Return name of line identified by id
 * or NULL if no such line
 *
 * Caller is responsible for freeing the returned string
 */
char *
     UAIdToName(int id);

/* Convert an error code to a string
 *
 * caller is responsible for freeing the returned string
 */
char *
     UAErrCodeToErrString(int errCode);

/************************************************************ End Prototypes */

#endif					/* ACOMM_H */
