%{
/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
*  Yacc grammar for Klone                                                     *
*                                                                             *
\*****************************************************************************/

#define IN_YACC_PARSER
#include "klparser.h"


%}

%union{
    KlO KlObject;
    KlCollection Kl_collection;
}

%type <KlObject> s_expression main_s_exp 
%type <Kl_collection> list_of_s_expressions

%token  END_OF_FILE 	/* MUST be the first token! */
%token  STRING NON_CLOSED_STRING QUOTECHAR BINEXPR BADBINEXPR
%token  NUMBER HEX_NUMBER SYMBCHAR CHAR CTRLCHAR
%token  REAL_NUMBER
%token  LEFTPAR RIGHTPAR LEFTBRA RIGHTBRA 
%token LEFTSQUARE 
%token RIGHTSQUARE LEFTSHARPSQUARE
%token  BACKQUOTE UNQUOTE UNQUOTESPLICING
%token  NAME PACKNAME
%token  LEFTPARVECTOR
%token UNSIGNED_NUMBER

%start main_s_exp 

%%
main_s_exp	: s_expression
			{$$ = KlReadExpr = $1;
			 YYACCEPT;}
		| /* empty */ RIGHTPAR main_s_exp
			{$$ = KlReadExpr = $2;
			 YYACCEPT;}
		| /* empty */ END_OF_FILE
			{$$ = KlReadExpr = NULL;
			 YYACCEPT;}
		;

s_expression	: LEFTPAR list_of_s_expressions RIGHTPAR
			{$$ = (KlO) KlListMake($2);}
		| LEFTBRA list_of_s_expressions RIGHTBRA
			{$$ = KlCollectionEvalOnLine($2);
			 if (!$$) {
			     KlReadExpr = NULL;
			     yyerror("Error in inline function");
			     YYABORT;
			 }
		     }
		| LEFTPARVECTOR list_of_s_expressions RIGHTPAR
			{$$ = (KlO) KlVectorMakeQ($2);}
		| LEFTSHARPSQUARE list_of_s_expressions RIGHTSQUARE
			{
			    if (((KlList) $2)->size < 2 || 
                                (((KlList) $2)->size == 2 &&
			         ((KlList) $2)->list[0] == (KlO) KlA_equal)
                               ) {
				yyerror("A locator #[...] needs more elements");
				YYABORT;
			    }
			    $$ = (KlO) KlLocatorMakeFromColl($2);
			}
		| LEFTSQUARE list_of_s_expressions RIGHTSQUARE
			{
			    if (((KlList) $2)->size < 2 || 
                                (((KlList) $2)->size == 2 &&
			         ((KlList) $2)->list[0] == (KlO) KlA_equal)
                               ) {
				yyerror("A message [...] needs more elements");
				YYABORT;
			    }
			    $$ = (KlO) KlKoMessageMakeFromColl($2);
			}
		| NAME
			{$$ = (KlO) KlInternBytes(yyleng, yytext);}
                | PACKNAME
		  	{$$ = (KlO) KlPacknameMake(yyleng, yytext);} 
		| NUMBER
			{$$ = (KlO) KlNumberMake((Int) atoi(yytext));}
		| REAL_NUMBER
			{double x;
			 KlParseReals(x);
			 $$ = (KlO) KlRealMake(x);}
		| HEX_NUMBER
			{int num;
			 sscanf(yytext+2,"%x",&num);
			 $$ = (KlO) KlNumberMake((Int) num);}
		| UNSIGNED_NUMBER
			{$$ = (KlO) KlUnsignedMakeFromString(yytext);}
		| STRING {
		    int sslen;
		    char *ss = KlStripString(yyleng, yytext, &sslen);
		    $$ = (KlO) KlStringMakeFromBytes(sslen, ss);}
		| QUOTECHAR s_expression
			{$$ = (KlO) KlQuotedExprMake($2);}
		| BACKQUOTE s_expression
			{$$ = (KlO) KlBackQuotedExprMake($2);}
		| UNQUOTE s_expression
			{$$ = (KlO) KlUnquoteExprMake($2);}
		| UNQUOTESPLICING s_expression
			{$$ = (KlO) KlUnquoteSplicingExprMake($2);}
		| NON_CLOSED_STRING 
		        {$$ = KlReadExpr = NULL;
			    yyerror("Non closed string");
		            YYABORT;
			}
		| LEFTPAR list_of_s_expressions END_OF_FILE
			{$$ = KlReadExpr = NULL;
			    yyerror("Lacking \")\" at the end of file!");
			    YYABORT;
			}
		| CHAR
			{$$ = (KlO) KlNumberMake(yytext[2]);}
		| CTRLCHAR
			{$$ = (KlO) KlNumberMake((yytext[3] - 64) % 32);}
		| SYMBCHAR
                        {int charcode = KlSymbCharParse(yytext+2);
			if (charcode == -1) {
			    yyerror("Invalid character name");
			    YYABORT;
			 } else {			
			     $$ = (KlO) KlNumberMake(charcode);
			 }
			}
 		| BINEXPR
			{$$ = KlReadExprBin;}
 		| BADBINEXPR
			{$$ = NIL;yyerror("Bad BinExpr");}
		| error 
			{$$ = NIL;}
		;

list_of_s_expressions : list_of_s_expressions s_expression
			{$$ = KlCollectionAdd($1, $2);}
		| /* empty */
			{$$ = KlCollectionMake();}
		;


%%

static char *Klyyerrorstring;

yyerror(s)
char *s;
{
    Klyyerrorstring = s;
}

static int Klyyparsing;

KlyyparseSyntaxError(why)
    char *why;
{
    /* set back flag to 0 since this error cannot be corrected */
    Klyyparsing = 0;
    KlError1s(KlE_SYNTAX_ERROR, why);
}

int
Klyyparse()
{
    if (Klyyparsing) {			/* we cannot re-enter parser! */
	return (int) KlError1s(KlE_SYNTAX_ERROR,
			 "Parser not reentrant: cannot call read in a read");
    } else {
	Klyyparsing = 1;
    }
    if (KlyyparseRaw()) {		/* abort */
	Klyyparsing = 0;
	return (int) KlError1s(KlE_SYNTAX_ERROR, Klyyerrorstring);
    } else {				/* accept */
	Klyyparsing = 0;
	return 0;
    }
}
