/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
* KLKO                                                                        *
* BODY                                                                        *
*                                                                             *
\*****************************************************************************/
/* Klone Klonable Objects
 */
#include "EXTERN.h"
#include "klone.h"
#include "kl_number.h"
#include "kl_atom.h"
#include "kl_list.h"
#include "kl_coll.h"
#include "kl_string.h"
#include "kl_stream.h"
#include "INTERN.h"
#include "klko.h"

KlKoMessage
KlKoMessageMakeFromColl(coll)
    KlCollection coll;
{
    KlKoMessage obj = (KlKoMessage) KlListMake(coll);
    obj->type = KlKoMessageType;
    return obj;
}

KlO
KlKoMessagePrint(obj, stream)
    KlKoMessage obj;
    KlStream stream;
{
    int i;
    KlO *p = obj->list;

    KlSPutc('[', stream);
    for (i = 0; i < obj->size; i++, p++) {
	if (i)
	    KlSPutc(' ', stream);
	KlSend_print(*p, stream);
    }
    KlSPutc(']', stream);
    return (KlO) obj;
}

/*****************************************************************************\
* 				     INIT                                     *
\*****************************************************************************/

KlKoInit()
{

    KlDeclareSubType(&KlKoMessageType, "Message", KlListType,
		     sizeof(struct _KlList));
    KlDeclareMethod1(KlKoMessageType, KlSelPrint, KlKoMessagePrint);
    KlDeclareMethodUndefined(KlKoMessageType, KlSelExecute);
    KlDeclareMethodUndefined(KlKoMessageType, KlSelApply);

    /* temporary fix to get some back-compat with old code */
    {
	extern KlO KlLocatorSetq(), KlLocatorEval();
	KlDeclareMethod1(KlKoMessageType, KlSelEval, KlLocatorEval);
	KlDeclareMethod1(KlKoMessageType, KlSelSetq, KlLocatorSetq);
    }
    
}
