/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/**************\
*              *
*  KlO  Stream *
*  DEFINITIONS *
*              *
\**************/

#ifndef INCLUDE_Kl_STREAM_H
#define INCLUDE_Kl_STREAM_H

/* type */

/* this is a dual type, consisting of string and file (default) streams
 */

#define KlStreamStringType 0		/* values of subtype field */
#define KlStreamFileType 1
#define KlStreamProcessType 3		/* process is also a file stream */

#define KlUNPUT_BUFFER_SIZE 4

typedef struct _KlStreamString {
    KlKLONE_HEADER;
    KlString klstring;			/* dynamic buffer */
    char subtype;
    char direction;
    char blocking;			/* unused */
    char blocking_write;		/* unused */
    int lineno;
    char unput[KlUNPUT_BUFFER_SIZE];	/* common part stops here */
    int cursor;
    int limit;
}              *KlStreamString;

typedef struct _KlStream {
    KlKLONE_HEADER;
    FILE *fd;
    char subtype;
    char direction;
    char blocking;			/* fd mode */
    char blocking_write;		/* write_fd mode */
    int lineno;
    char unput[KlUNPUT_BUFFER_SIZE];	/* common part stops here */
    char *name;
    char *is_reading_file;
    FILE *write_fd;			/* for 2-ways R/W streams */
}        *KlStream;


/* exported variables */

EXT KlStream KlStdin;
EXT KlStream KlStdout;
EXT KlStream KlStderr;
EXT KlStream KlStdyy;
EXT KlStreamString KlStdpool;

EXT char KlSPutc_char;

extern char *KlStreamDirectionsText[];

#define KlStreamOREAD 1
#define KlStreamOWRITE 2

#define KlStreamCanREAD(o) if (!((o)->direction & KlStreamOREAD)) { \
    KlError2(KlE_STREAM_ERROR, KlA_read, o);}
#define KlStreamCanWRITE(o) if (!((o)->direction & KlStreamOWRITE)) { \
    KlError2(KlE_STREAM_ERROR, KlA_write, o);}

#define KlStreamWriteFd(obj) ((obj)->write_fd ? (obj)->write_fd : (obj)->fd)

/* exported functions */

EXT KlStream KlStreamMake();
EXT KlStreamString KlStreamStringMake();
EXT KlO KlStreamPrint();
EXT KlO KlStream_equal();
EXT KlStream KlStream_match();
extern KlStream KlStdyyRedirect();
EXT KlO KlFlush();
EXT char *KlFGets();
EXT char *KlGets();

/* exported objects */

/* methods */

EXT KlType KlStreamType;

/* macros */

#define KlIsAStream(obj) ((obj)->type == KlStreamType)
#define KlMustBeStream(o, n) KlArgumentMustBe(o, n, KlStreamType)

#define KlIsAStringStream(obj) ((obj)->subtype == KlStreamStringType)
#define KlIsAFileStream(obj) ((obj)->subtype == KlStreamFileType)

/* prints a char */
#define KlSPutc(ascii_code, stream) \
    (KlSPutc_char = ascii_code, KlSPutBytes(1, &KlSPutc_char, stream))

/* Macro to probe the stdio buffer to see if any data is pending in the
 * buffer.  Different versions are provided for System V and BSD stdio.
 */

#ifdef __SLBF
#   define READ_DATA_PENDING(fp) (fp->_r > 0)
#else /* !__SLBF */
# ifdef LINUX
#   define READ_DATA_PENDING(fp) ((fp)->_IO_read_ptr - (fp)->_IO_read_base)
# else /* !LINUX */
#   define READ_DATA_PENDING(fp) (fp->_cnt != 0)
# endif /* !LINUX */
#endif /* !__SLBF */

#ifdef USE_FILENO
#define KlFp2Fd(fp) fileno(fp)
#else /* !USE_FILENO */

#ifndef fileno
#define KlFp2Fd(fp) (fp)->_file		/* should be portable */
#else
#define KlFp2Fd(fp) fileno(fp)
#endif

#endif /* !USE_FILENO */
#endif					/* INCLUDE_Kl_STREAM_H */
