/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/**************\
*              *
*  KlO  Atom   *
*  DEFINITIONS *
*              *
\**************/

#ifndef INCLUDE_Kl_ATOM_H
#define INCLUDE_Kl_ATOM_H

/* type */

/* all symbols inherits from this structure 
 * in fact all derived atoms can have up to 5 fields (max is KlActive)
 * so that they stay in the same malloc bucket
 */

typedef struct _KlAtom {
    KlKLONE_HEADER;			/* common part (external infos) */
    char *p_name;
    KlO p_list;		
    KlO c_val;				/* private part (internal infos) */
    Int unbound;			/* flag if makunbounded */
    KlO dummy;
}      *KlAtom;

typedef struct _KlConstant {
    KlKLONE_HEADER;
    char *p_name;
    KlO p_list;				/* list in fact */
    KlO c_val;
    Int unbound;			/* flag if makunbounded */
    KlO dummy;
}          *KlConstant;

typedef struct _KlKeyword {
    KlKLONE_HEADER;
    char *p_name;
    KlO p_list;				/* list in fact */
    KlAtom atom;
    KlO k_val;
    Int k_count;
}         *KlKeyword;

typedef struct _KlActive {
    KlKLONE_HEADER;
    char *p_name;			/* same as for atoms */
    KlO p_list;				/* list in fact */
    KlO data;				/* private data passed to funcs */
    KlMethod get;			/* (*get) (data) */
    KlMethod set;			/* (*set) (value, data) */
}        *KlActive;

typedef struct _KlKloneActive {
    KlKLONE_HEADER;
    char *p_name;			/* same as for atoms */
    KlO p_list;				/* list in fact */
    KlO data;				/* stored Klone data */
    KlO get;				/* (get obj data) */
    KlO set;				/* (set obj value) */
}        *KlKloneActive;

typedef struct _KlSymbolSlot {
    KlKLONE_HEADER;
    KlAtom symbol;
}        *KlSymbolSlot;

/* exported functions */

EXT KlAtom KlIntern();
EXT KlAtom KlInternBytes();
EXT KlO KlAtomEval();
EXT KlO KlAtomPrint();
EXT KlO KlAtomFree();
EXT KlO KlAtomExecute();
EXT KlO KlAtomSetq();
EXT KlO KlAtomEqual();
EXT KlAtom find_next_prefixed_atom();
EXT KlO KlAtomUnbind();
extern KlConstant KlConstantMake();
extern KlO KlAtomCoerce();
extern KlO KlKeywordCoerce();
extern KlKeyword KlKeywordMakeFromAtom();
EXT KlActive KlActiveMake();
EXT KlO KlActiveEval();
EXT KlO KlActiveExecute();
EXT KlO KlActiveSetq();
EXT KlAtom KlInternDotPrefixed();
EXT KlO KlActivePointerToIntGet();
EXT KlO KlActivePointerToIntSet();
extern KlO KlSymbolSlotCoerce();
extern KlAtom KlDeclareSubType();
extern KlActive KlActivePointerToBooleanMake();

extern KlActive KlActivePointerToKloneStringMake();
extern KlAtom KlErrorCodeMakeS();
extern KlAtom KlErrorCodeMakeSRecoverable();

#define KlKeywordMake(a) ((KlKeyword) KlIntern(a))	/* backward compat */

/* macro to access the fields */

#define KlActiveSet(a) ((a)->set)
#define KlActiveGet(a) ((a)->get)
#define KlActiveData(a) ((a)->data)

#define KlAtomPList(a) ((KlList)((a)->p_list))
#define KlAtomPListSet(a, v) (((a)->p_list) = ((KlO) (v)))

/* exported variables */

EXT KlKeyword *KlValidKeywords;
EXT KlKeyword *KlValidKeywordsPtr;

EXT int KlKCount 
INIT(2);				/* the current keyword func call */
EXT int KlAtomCreated 
INIT(0);				/* set to 1 by KlIntern */
EXT KlAtom KlCurVariable;		/* to print errors */
EXT KlAtom KlTmpAtom;			/* temp to declare atoms */

/* atoms */
EXT KlAtom KlA_progn;			/* the progn atom */
EXT KlActive KlA_star_package;		/* *package* */
EXT KlAtom KlA_nil_symbol;		/* internal use only */
EXT KlAtom KlA_documentation;		/* internal use only */
EXT KlAtom KlA_print_binary;		/* format of prints for strings */
EXT KlAtom KlA_print_readably;		/* format of prints for strings */
EXT KlAtom KlA_print;			/* print for list pretty-printing */
EXT KlAtom KlA_load_path;		/* list of directories */
EXT KlAtom KlA_load_ext;		/* extension possible for files */
EXT KlAtom KlA_EOF;			/* EOF for catching */
EXT KlAtom KlA_EOP;			/* EOP (end-of-pipe) */
EXT KlAtom KlA_ERROR;			/* Error for catching */
EXT KlAtom KlA_ALL;			/* catch-all tag */
EXT KlAtom KlA_error_handlers;		/* list of error handlers */
EXT KlAtom KlA_error_handlers_orig;	/* default error handler */
EXT KlAtom KlA_error_correctors;	/* list of error correctors */
EXT KlAtom KlA_smartloader;		/* smartloader */
EXT KlAtom KlA_is_in_error_handler;	/* flag not to recurse in errors */
EXT KlAtom KlA_quote;			/* ' */
EXT KlAtom KlA_backquote;		/* ` */
EXT KlAtom KlA_unquote;			/* , */
EXT KlAtom KlA_unquotesplicing;		/* ,@ */
EXT KlAtom KlA_KlVersionNumber;		/* *version* */
EXT KlAtom KlA_KlApplicationName;	/* *application-name* */
EXT KlAtom KlA_KlMachineName;		/* *machine* */
EXT KlAtom KlA_Class;			/* Class */
EXT KlAtom KlA_Object;			/* Object */
EXT KlAtom KlA_Expr;			/* Expr */
EXT KlAtom KlA_Subr;			/* Subr */
EXT KlAtom KlA_GenericFunction;		/* GenericFunction */
EXT KlAtom KlA_read;			/* read */
EXT KlAtom KlA_write;			/* write */
EXT KlAtom KlA_continue;		/* continue */
EXT KlAtom KlA_lambda;			/* lambda */
EXT KlAtom KlA_lambdaq;			/* lambdaq */
EXT KlAtom KlA_lambdam;			/* lambdam */
EXT KlAtom KlA_Int;			/* for structs */
EXT KlAtom KlA_String;
EXT KlAtom KlA_make_instance;
EXT KlAtom KlA_init;
EXT KlAtom KlA_free;
EXT KlAtom KlA_execute;
EXT KlAtom KlA_equal;
EXT KlAtom KlA_add;
EXT KlAtom KlA_nth;
EXT KlAtom KlA_hash;
EXT KlAtom KlA_eval;
EXT KlAtom KlA_copy;
EXT KlAtom KlA_setq;
EXT KlAtom KlA_get;
EXT KlAtom KlA_put;
EXT KlAtom KlA_delete;
EXT KlAtom KlA_insert;
EXT KlAtom KlA_class;
EXT KlAtom KlA_object;
EXT KlAtom KlA_selector;
EXT KlAtom KlA_slot;
EXT KlAtom KlA_name;
EXT KlAtom KlA_body;
EXT KlAtom KlA_correctable;
EXT KlAtom KlA_length;
EXT KlAtom KlA_apply;
EXT KlAtom KlA_make_subr;
EXT KlAtom KlA_is_in_dbtk_break;

/* markers */
EXT KlAtom KlA_Moptional;		/* &optional marker */
EXT KlAtom KlA_Mrest;			/* &rest marker */
EXT KlAtom KlA_Mkey;			/* &key marker */
EXT KlAtom KlA_Maux;			/* &aux marker */
EXT KlAtom KlA_Mwhole;			/* &whole marker */
EXT KlAtom KlA_Mallow_other_keys;	/* &allow-other-keys marker */

/* keywords */
EXT KlKeyword KlK_direction;
EXT KlKeyword KlK_if_exists;
EXT KlKeyword KlK_type;
EXT KlKeyword KlK_buffered;
EXT KlKeyword KlK_output;
EXT KlKeyword KlK_input;
EXT KlKeyword KlK_error;
EXT KlKeyword KlK_io;
EXT KlKeyword KlK_overwrite;
EXT KlKeyword KlK_string;
EXT KlKeyword KlK_supersede;
EXT KlKeyword KlK_append;
EXT KlKeyword KlK_initial_element;
EXT KlKeyword KlK_real;
EXT KlKeyword KlK_user;
EXT KlKeyword KlK_sys;
EXT KlKeyword KlK_cpu;
EXT KlKeyword KlK_initform;
EXT KlKeyword KlK_documentation;
EXT KlKeyword KlK_nil;
EXT KlKeyword KlK_true;
EXT KlKeyword KlK_writer;
EXT KlKeyword KlK_metaclass;
EXT KlKeyword KlK_name;
EXT KlKeyword KlK_father;
EXT KlKeyword KlK_son;
EXT KlKeyword KlK_brother;
EXT KlKeyword KlK_methods;
EXT KlKeyword KlK_slots;
EXT KlKeyword KlK_STAR_inits;
EXT KlKeyword KlK_exo_hooks;
EXT KlKeyword KlK_file;
EXT KlKeyword KlK_blocking;
EXT KlKeyword KlK_timeout;
EXT KlKeyword KlK_nohup;
EXT KlKeyword KlK_if_does_not_exist;

/* actives */
EXT KlActive  KlA_StackMaxSize;

/* error messages
 */

EXT KlAtom KlE_UNDEFINED_VARIABLE;
EXT KlAtom KlE_BAD_NUMBER_OF_ARGS;
EXT KlAtom KlE_UNDEFINED_FUNCTION;
EXT KlAtom KlE_BAD_DEFUN;
EXT KlAtom KlE_BAD_ARG_TYPE;
EXT KlAtom KlE_RELEASING_ATOM;
EXT KlAtom KlE_BAD_LOCAL_SYNTAX;
EXT KlAtom KlE_SYNTAX_ERROR;
EXT KlAtom KlE_INTERNAL_ERROR;
EXT KlAtom KlE_TIME_EXCEEDED;
EXT KlAtom KlE_CANNOT_SET;
EXT KlAtom KlE_CANNOT_GET_C_VALUE;
EXT KlAtom KlE_NON_KlO;
EXT KlAtom KlE_UNDEFINED_METHOD;
EXT KlAtom KlE_NO_COERCION;
EXT KlAtom KlE_ERROR_OPENING_FILE;
EXT KlAtom KlE_BAD_DIRECTORY;
EXT KlAtom KlE_STREAM_ERROR;
EXT KlAtom KlE_INVALID_KEYWORD;
EXT KlAtom KlE_INVALID_KEYWORD_VALUE;
EXT KlAtom KlE_BAD_DO_SYNTAX;
EXT KlAtom KlE_DIVIDE_BY_ZERO;
EXT KlAtom KlE_NO_ELEMENT;
EXT KlAtom KlE_NO_METHOD;
EXT KlAtom KlE_NO_CLASS;
EXT KlAtom KlE_BAD_CLASS_DEF;
EXT KlAtom KlE_NO_PREVIOUS_METHOD;
EXT KlAtom KlE_MAX_ARITY;
EXT KlAtom KlE_STACK_OVERFLOKl;
EXT KlAtom KlE_NO_CATCH;
EXT KlAtom KlE_NO_PUT;
EXT KlAtom KlE_BAD_COMPARE_CALL;
EXT KlAtom KlE_BAD_REGEXPR;
EXT KlAtom KlE_BAD_SYMBCHAR;
EXT KlAtom KlE_BAD_LAMBDALIST;
EXT KlAtom KlE_BREAK;
EXT KlAtom KlE_DBTK_BREAK;
EXT KlAtom KlE_ERROR;
EXT KlAtom KlE_CANNOT_LOAD_FILE;
EXT KlAtom KlE_BAD_ACCESS;
EXT KlAtom KlE_NOT_A_METHOD;
EXT KlAtom KlE_COMMA_OUTSIDE_BACKQUOTE;
EXT KlAtom KlE_NO_MODIFY;
EXT KlAtom KlE_UNDEFINED_INTERNAL_METHOD;
EXT KlAtom KlE_NUMBER_OUT_OF_RANGE;
EXT KlAtom KlE_BAD_LOCATOR;

#ifdef CHECK_FILE_TYPE_ON_LOAD
EXT KlAtom KlE_INVALID_LOAD_FILE;
#endif /* CHECK_FILE_TYPE_ON_LOAD */
EXT KlAtom KlE_NO_METACLASS_INSTANCE;
EXT KlAtom KlE_CANNOT_DECLARE_GENERIC;
EXT KlAtom KlE_NUMERIC_ERROR;
EXT KlAtom KlE_INVALID_IDENTIFIER;
#ifdef DEBUG2
EXT KlAtom KlE_BAD_STACK;
#endif

/* methods */

EXT KlType KlAtomType;
EXT KlType KlKeywordType;
EXT KlType KlConstantType;
EXT KlType KlActiveType;
EXT KlType KlKloneActiveType;
EXT KlType KlSymbolSlotType;

EXT KlO KlMallocStats();
#ifdef STATS
EXT KlO KlHashstats();
#endif					/* STATS */

/* macros */

#define KlIsASymbol(obj) KlHasTrait(obj, KlTrait_symbol)
#define KlMustBeSymbol(o, n) KlArgumentMustHaveTrait(o, n, KlTrait_symbol)

#define KlIsAKeyword(obj) ((obj)->type == KlKeywordType)
#define KlMustBeKeyword(o, n) KlArgumentMustBe(o, n, KlKeywordType)

#define KlIsAnAtom(obj) ((obj)->type == KlAtomType)
#define KlMustBeAtom(o, n) KlArgumentMustBe(o, n, KlAtomType)

#define KlIsAConstant(obj) ((obj)->type == KlConstantType)
#define KlMustBeConstant(o, n) KlArgumentMustBe(o, n, KlConstantType)

#define KlIsAActive(obj) ((obj)->type == KlActiveType)
#define KlMustBeActive(o, n) KlArgumentMustBe(o, n, KlActiveType)

#ifdef DEBUG
#define KlKeyVal(key, def) (\
    *KlValidKeywordsPtr++ = key, *KlValidKeywordsPtr = 0,\
    ((KlValidKeywordsPtr - KlValidKeywords)<KLMAX_KEYWORDS ? 0 : \
     KlFatalError(11, KLMAX_KEYWORDS)), \
    (key->k_count-- == KlKCount ? key->k_val : ((KlO) (def))))
#else /* !DEBUG */
#define KlKeyVal(key, def) (\
    *KlValidKeywordsPtr++ = key, *KlValidKeywordsPtr = 0,\
    (key->k_count-- == KlKCount ? key->k_val : ((KlO) (def))))
#endif /* !DEBUG */

#define KlEnvVal(atom, def) \
    ((atom->c_val != KlUndef) ? atom->c_val : ((KlO) (def)))

#define KlIsAMarker(obj) \
    ((obj)->type == KlAtomType && ((KlAtom)(obj)->p_name[0] == '&'))

#define KlAtomOrKey(obj) \
    (KlIsAKeyword(obj) ? ((KlKeyword)(obj))->atom : ((KlAtom) obj))

#define KlKeyFromAtom(obj) \
    (KlIsAKeyword(obj) ? ((KlKeyword)(obj)) : KlKeywordMakeFromAtom(obj))

#endif					/* INCLUDE_Kl_ATOM_H */
