/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: mklone.c,v 0.0.1.1 1995/04/07 12:06:50 oarsac Exp $ */

#include "global.h"
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/Editres.h>
#include <stdio.h>
#include <assert.h>
#include "KlLib.h"
#include "kl_motif.h"
#ifdef USE_CANVAS
#include <Kn/Knvas.h>
#endif /* USE_CANVAS */
#include "kl_widget.h"
#include "kl_classes.h"
#include "kl_convert.h"

#include "boot-klm.h"

#define STDIN_FD 0


GlobalRec klm;			/* global record */


#define KlMustBeExecutable(o, n) if(KlIsUndefinedMethod(o,KlSelExecute )) \
KlArgumentMustHaveTrait(o, n, KlTrait_function)


void
KlExecuteCallbackProc(Widget w, XtPointer client_data, XtPointer call_data)
{
    KlList func = (KlList)client_data;
    
    assert(func);
    KlArgumentMustHaveTrait(func, 0, KlTrait_list);
    KlSend_eval(func);
}



void
KlExecuteTimerProc(XtPointer client_data, XtIntervalId *id)
{
    KlList func = (KlList)client_data;
    
    assert(func);
    KlArgumentMustHaveTrait(func, 0, KlTrait_list);
    KlSend_eval(func);
}




void
KlExecuteInput(XtPointer client_data, int *source, XtInputId *id)
{
    KlList func = (KlList)client_data;
    
    assert(func);
    KlArgumentMustHaveTrait(func, 0, KlTrait_list);
    KlSend_eval(func);
}


void
KloneInput(XtPointer cdata, int *fd, XtInputId *id)
{
    KlPoolToplevel(); 
}




KlWidget
KlToplevelMake(KlString name, KlString class)
{
    Widget toplevel;
    KlList list;
    Int i;
    KlString str;
    String *fallbacks;
    String shell_name;
    KlWidget result;
    KlAtom KlA_falllback_resources = KlIntern("*fallback-resources*");
    list = (KlList)KlA_falllback_resources->c_val;
    
    assert(list);
    assert(class);
    if(list->type == KlListType) {
	fallbacks = (String *)KlAlloca(sizeof(String) * (list->size+1));
	for(i = 0; i <list->size; i++) {
	    str = (KlString)list->list[i];
	    assert(str);
	    KlArgumentMustBe(str, 0, KlStringType);
	    fallbacks[i] = str->string;
	}
	fallbacks[list->size] = NULL;
	XtAppSetFallbackResources(klm.app, fallbacks);
    }
    /* well, openning multiple displays is not really necessary ... but
       it is required if we wanna load the fallback resources */
    klm.dpy = XtOpenDisplay(klm.app, (char *)NULL, NULL, class->string, 
			0, 0, &(klm.argc), klm.argv);


    shell_name = name->string;
    if(0 == strlen(shell_name)) {
	shell_name = 0;
    }
    toplevel = 	
	XtAppCreateShell(shell_name, class->string, 
			 applicationShellWidgetClass, klm.dpy, 0, 0);

    XtAddEventHandler(toplevel, 0, True, _XEditResCheckMessages, NULL);

    
    result =  KlWidgetMake(toplevel);
    KlListAppend(klm.toplevels, result);
    return result;

}


KlO
KlObserveInput(KlStream stream, KlO func, KlO closure)
{
    KlList list;

    assert(stream);
    list = KlListNMake(0);
    KlIncRef(list);
    KlListAppend(list, func);
    KlListAppend(list, stream);
    KlListAppend(list, closure);

    XtAppAddInput(klm.app,
		  fileno(stream->fd),
		  (XtPointer)XtInputReadMask,
		  (XtInputCallbackProc)KlExecuteInput,
		  (XtPointer)list);
    return (KlO)stream;
}    




void
KlWidgetRealize(KlWidget klw)
{
    assert(klw->w);
    XtRealizeWidget(klw->w);
    XSync(XtDisplayOfObject(klw->w), False);
    XmUpdateDisplay(klw->w);
}



KlWidget
KlWidgetManage(KlWidget klw)
{
    assert(klw->w);
    XtManageChild(klw->w);
    XFlush(XtDisplayOfObject(klw->w));
}



KlWidget
KlWidgetUnmanage(KlWidget klw)
{
    assert(klw->w);
    XtUnmanageChild(klw->w);
    XFlush(XtDisplayOfObject(klw->w));
}




static void
PrintResourceList(KlWidgetClass wc)
{
    Cardinal i;
    assert(wc);
    printf("Resources for class %s:\n", wc->class);
    for(i = 0; i < wc->num; i++){
	printf("  %.32s of type %s\n", wc->resources[i].resource_name,
	       wc->resources[i].resource_type);
    }
}



KlWidget
KlWidgetListResources(KlWidget klw)
{
    KlWidgetClass wc = NULL;

    wc = (KlWidgetClass)KlGetWidgetClass(klw);
    if(! wc) {
	XtAppWarning(XtWidgetToApplicationContext(klw->w),
		     "Cannot find widget class.");
	return (KlWidget)NIL;
    }
    if(! wc->resources) {
	XtGetResourceList(klw->w->core.widget_class,
			  &(wc->resources), &(wc->num));
    }
    PrintResourceList(wc);
    return (KlWidget)TRU;
}





KlWidget
KlWidgetSetValue(KlWidget klw, KlString name, KlString value)
{
    assert(klw);
    assert(value);
    assert(name);
    
    KlMustBeWidget(klw, 0);
    KlArgumentMustHaveTrait(name, 1, KlTrait_string);
    KlArgumentMustHaveTrait(value, 2, KlTrait_string);
    XtVaSetValues(klw->w, XtVaTypedArg,
		  name->string, XtRString, (XtArgVal)value->string, 
		  strlen(value->string),
		  0);
    XFlush(XtDisplayOfObject(klw->w));
    return klw;
}


static void
SetBooleanCB(Widget w, XtPointer client, XtPointer call)
{
    Boolean *b = (Boolean *)client;
    *b = True;
}



KlO
KlLocalLoop(KlWidget klw)
{
    XEvent e;
    Widget shell;
    volatile Boolean end_loop = False;
    volatile Boolean result = False;

    KlMustBeWidget(klw, 0);
    if( ! (XmIsMessageBox(klw->w) || XmIsSelectionBox(klw->w))) {
	XtAppWarning(klm.app,
		   "localloop actually requires a MessageBox or SelectionBox subclass.");
	return NIL;
    }
    shell = XtParent(klw->w);
    XtAddCallback(shell, XmNpopdownCallback,
		  SetBooleanCB, (XtPointer)&end_loop);
    XtAddCallback(klw->w, XmNokCallback, SetBooleanCB, (XtPointer)&result);
		  
    while(! end_loop) {
	XtAppNextEvent(klm.app, &e);
	XtDispatchEvent(&e);
    }
    XtRemoveCallback(shell, XmNpopdownCallback, SetBooleanCB,
		     (XtPointer)&end_loop);
    XtAddCallback(klw->w, XmNokCallback, SetBooleanCB, (XtPointer)&result);

    return result ? TRU : NIL;
}    



KlWidget
KlBindCallback(KlWidget klw, KlString name, KlList value)
{
    char cbname[64];
    
    assert(name);
    assert(klw);
    KlMustBeWidget(klw, 0);
    KlArgumentMustHaveTrait(name, 1, KlTrait_string);
    KlMustBeExecutable(value, 2);
    sprintf(cbname, "%sCallback", name->string);
    KlIncRef(value);
    XtAddCallback(klw->w, cbname, KlExecuteCallbackProc, value);
}



KlWidget
KlAddTimeout(KlNumber tms, KlList value)
{
    assert(tms);
    KlArgumentMustHaveTrait(tms, 0, KlTrait_number);
    KlMustBeExecutable(value, 1);
    
    KlIncRef(value);

    XtAppAddTimeOut(klm.app, tms->number, KlExecuteTimerProc, value);
}



KlWidget
KlGetWidgetFromName(KlWidget parent, KlString name)
{
    Widget root = NULL, w = NULL;
    String sname;
    Cardinal n;
    if((KlO)parent != NIL) {
	KlMustBeWidget(parent, 0);
	root = parent->w;	
    }
    KlArgumentMustHaveTrait(name, 0, KlTrait_string);
    sname = name->string;
    
    if(root) {
	w = XtNameToWidget(root, sname);
    }
    else  if(sname[0] == '^'){
	/* ABSOLUTE PATH NAME */
	String rest;
	
	sname = &(sname[1]);
	rest = strchr(sname, '.');
	if(rest) {
	    *rest = 0;
	    rest++;
	}
	for(n = 0; n < klm.toplevels->size; n++) {
	    parent = (KlWidget)klm.toplevels->list[n];
	    root = parent->w;
	    if(! strcmp(XtName(root), sname)) {
		if(rest)
		    w = XtNameToWidget(root, rest);
		else
		    w = root;
		if(w)
		    break;
	    }
	}
    }
    if(w) {
	return KlWidgetMake(w);
    }
    else {
	return (KlWidget)NIL;
    }
}



MkloneInitialize(int argc, char *argv[])
{
    klm.dpy = NULL;
    klm.app = NULL;
    klm.argc = 0;
    klm.argv = NULL;
    klm.toplevels = KlListNMake(0);
    KlIncRef(klm.toplevels);
    
    KlWidgetClassInitialize();
    
    KlDeclareSubr(KlWidgetRealize, "build", 1);
    KlDeclareSubr(KlWidgetManage, "show", 1);
    KlDeclareSubr(KlWidgetUnmanage, "hide", 1);
    KlDeclareSubr(KlWidgetSetValue, "customize", 3);
    KlDeclareSubr(KlBindCallback, "callback", 3);
    KlDeclareSubr(KlObserveInput, "observe", 3);
    KlDeclareSubr(KlAddTimeout, "timeout", 2);
    KlDeclareSubr(KlGetWidgetFromName, "get-widget", 2);
    KlDeclareSubr(KlLocalLoop, "localloop", 1);
    
    
    /* could become a pseudo-resource */
    KlDeclareSubr(KlWidgetListResources, "resources", 1);

    KlRegisterWidgetClasses();
    
    KlDeclareSubr(KlToplevelMake, "Toplevel", 2);

    AppAllModulesInit();


    KlExecuteStringNoReturn(KlmBootCode);
    
    XtToolkitInitialize();
    klm.app = XtCreateApplicationContext();

    Tm_RegisterConverters(NULL, klm.app);
    RegisterKloneConverters(klm.app);

    klm.argc = argc;
    klm.argv = argv;
    
}






MkloneToplevel(int poolstdin)
{
    static done = False;
    if(poolstdin && ! done) {
	XtAppAddInput(klm.app, STDIN_FD, (XtPointer)XtInputReadMask, 
		      KloneInput, 0);
	done = True;
	KlPoolToplevel();	/* that will draw the prompt */
    }

    XtAppMainLoop(klm.app);

}


