/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: kl_widget.c,v 0.0.1.1 1995/04/07 12:06:50 oarsac Exp $ */


#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include "kl_widget.h"
#include "kl_classes.h"
#include "kl_convert.h"

/* This is private in the r5 distrib */
#if (XtSpecificationRelease < 6)
typedef struct {
    String      name;   /* resource name */
    String      type;   /* representation type name */
    XtArgVal    value;  /* representation */
    int         size;   /* size of representation */
} XtTypedArg, *XtTypedArgList;
#endif /*  (XtSpecificationRelease < 6) */


KlType KlWidgetType;
static KlHash widgets_table;	/* Hash table containing widgets */



extern KlO
KlWidgetGetValue(KlWidget klw, char *name);



KlO
KlWidgetGetParent(Widget w)
{
    Widget parent = XtParent(w);
    if(parent)
	return (KlO)KlWidgetMake(parent);
    else
	return NIL;
}



KlO
KlWidgetGetName(Widget w)
{
    return (KlO)KlStringMake(XtNewString(XtName(w)));
}


KlO
KlWidgetGetClass(Widget w)
{
    WidgetClass wc = XtClass(w);

    return (KlO)KlStringMake(XtNewString(wc->core_class.class_name));
}



KlO
KlWidgetGetWindow(Widget w)
{
    return (XtIsRealized(w) ? (KlO)KlNumberMake(XtWindow(w)) : NIL);
}


KlO
KlWidgetIsManaged(Widget w)
{
    return XtIsManaged(w) ? TRU : NIL;
}


KlO
KlWidgetIsRealized(Widget w)
{
    return XtIsRealized(w) ? TRU : NIL;
}



/* returns the Klone object associated to the widget.

 * If there is always a klone object that holds the specified widget, returns
 * this objects, or create one and add it in the table.

 * returns: The previous or a new KlWidget*/
KlWidget
KlWidgetMake(Widget w)
{
    KlWidget res;
    
    res = (KlWidget)KlHashGet(widgets_table, (KlO)w, (KlO)NIL);
    if(NIL == (KlO)res) {		/* not found */
	res = (KlWidget)KlOMake(KlWidgetType);
	res->w = w;
	KlHashPut(widgets_table, w, (KlO)res);
    }
    return res;
}






KlO
KlWidgetExecute(KlWidget klw, KlList list)
{
    KlO result;
    KlString name;
    KlString value;
    char *svalue;
    Int i;
    int argc = list->size - 1;
    KlO *argv = list->list + 1;
    XtTypedArgList argument, nestedlist;

    if(argc == 1) {
	/* Get Value */
	name = (KlString)argv[0];
	return KlWidgetGetValue(klw, &(name->string[1]));
    }
    /* Set Values */
    if (argc > 1) {
	KlO *eval_list = KlAlloca(sizeof(KlO)*argc);
	KlO *dest = eval_list;
	KlO *last = argv + argc;

	while (argv < last) {
	    /* do not eval first argument (selector) */
	    *dest = *argv;
	    dest++, argv++;
	    /* eval selector's value */
	    *dest = KlSend_eval(*argv);
	    dest++, argv++;
	}
	/* Here, we use a nested list of arguments, because we cannot fill the
           arglist directly. This processes multiple SetValue in one call. */
	nestedlist =
	    (XtTypedArgList)KlAlloca(sizeof(XtTypedArg) * ((argc/2) + 1));
	argument = nestedlist;
	for(i = 0; i < argc; i+=2) {
	    name = (KlString) eval_list[i];
	    value = (KlString) eval_list[i+1];
	    
	    KlArgumentMustHaveTrait(name, 0, KlTrait_string);
	    if(KlHasTrait(value, KlTrait_number)) {
		/* numeric arguments are allowed */
		svalue = (char *)KlAlloca(8);
		sprintf(svalue, "%d", ((KlNumber)value)->number);
	    }
	    else if (KlHasTrait(value, KlTrait_list)) {
		/* for some resources List argument may be usefull */
		KlList lval = (KlList)value;
		KlString s;
		int j;
		/* BUGGY: allocate arbitrary big size */
		svalue = (char *)KlAlloca(32*lval->size);
		svalue[0] ='\0';
		for(j = 0; j < lval->size; j++) {
		    s = (KlString)lval->list[j];
		    /* a list may contain numbers */
		    if(KlHasTrait(s, KlTrait_number)) {
			char nbuf[8];
			sprintf(nbuf, "%d", ((KlNumber)s)->number);
			strcat(svalue, nbuf);
		    }
		    else {
			/* else it will be a string */
			KlArgumentMustHaveTrait(s, 0, KlTrait_string);
			strcat(svalue, s->string);
		    }
		    strcat(svalue, ", ");
		}
	    }
	    else if (value->type != KlWidgetType) {
		KlArgumentMustHaveTrait(value, 0, KlTrait_string);
		svalue = value->string;
	    }
	    argument->name = (String)&(name->string[1]);
	    
	    /* special case: widgets may not be converted from strings */
	    if(value->type == KlWidgetType) {
		/* WARNING !!! UGLY !!! USE A TABLE INSTEAD !!! */
		if(!strcmp(argument->name, XmNmenuHelpWidget)) {
		    argument->type = (String)XmRMenuWidget;
		}
		else {
		    argument->type = (String)XmRWidget;
		}
		argument->value = (XtArgVal)((KlWidget)value)->w;
		argument->size = (XtArgVal)sizeof(Widget);
	    }
	    else {
		/* by default, any argument should be converted from string */
		argument->type = (String)XtRString;
		argument->value = (XtArgVal)svalue;
		argument->size = (XtArgVal)strlen(svalue)+1; /* trailing 0 */
	    }
	    argument++;
	}
	argument->name =  NULL;
	argument->type =  NULL;
	argument->value =  NULL;
	argument->size =  NULL;
	XtVaSetValues(klw->w, XtVaNestedList, nestedlist, 0);
    }
    XFlush(XtDisplayOfObject(klw->w));
    return (KlO)klw;
}


KlO
KlWidgetApply(KlWidget klw, KlList list)
{
    KlO result;
    KlString name, value;
    Int i;
    int argc = list->size - 1;
    KlO *argv = list->list + 1;
    
    for(i = 0; i < argc; i+=2) {
	name = (KlString) argv[i];
	value = (KlString) argv[i+1];
	KlArgumentMustHaveTrait(name, 0, KlTrait_string);
	    KlArgumentMustHaveTrait(value, 0, KlTrait_string);
	XtVaSetValues(klw->w, XtVaTypedArg,
		      &(name->string[1]), XtRString,
		      (XtArgVal)value->string, strlen(value->string),
		      0);
    }
    XFlush(XtDisplayOfObject(klw->w));
    return (KlO)klw;
}


void
KlWidgetFree(KlWidget klw)
{
    /* nothing */
}


void
KlWidgetImport()
{
    
}

void
KlWidgetClassInitialize()
{
    KlList list;
    
    /* declare KlWidget type */
    KlDeclareType(&KlWidgetType, "KlWidget", sizeof(struct KlWidgetStruct));

    /* declare methods */
    KlDeclareMethod1(KlWidgetType, KlSelExecute, KlWidgetExecute);
    KlDeclareMethod1(KlWidgetType, KlSelApply, KlWidgetApply);
    KlDeclareMethod1(KlWidgetType, KlSelFree, KlWidgetFree);
    
    list = KlListNMake(0);
    widgets_table = KlHashMake(list);
    KlIncRef(widgets_table);
    widgets_table->ref_counted &= ~(KlHashRefK); /* do not IncRef */
}

