/* Copyright 1995 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: kl_convert.c,v 0.0.1.1 1995/04/07 12:06:50 oarsac Exp $ */

#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include <KlLib.h>
#include "kl_convert.h"
#include <X11/Xproto.h>


typedef struct ResAssocRec {
    String name_res;
    String num_res;
    int size;
} ResAssocRec, *ResAssoc;



static ResAssocRec res_assocs [] = {
    {	XmNchildren, 	XmNnumChildren,	sizeof(Cardinal)	}
};



/* returns the size of a list resource.

 * According to the association between a resource name and the related count
 * resource, this functions returns the list size.

 * returns: list size*/
int
GetListSize(Widget w, String res)
{
    int i;
    Arg args[1];
    for(i = 0; i <XtNumber(res_assocs); i++) {
	if(!strcmp(res, res_assocs[i].name_res)) {
	    if(sizeof(Cardinal) == res_assocs[i].size) {
		Cardinal count;
		XtSetArg(args[0], res_assocs[i].num_res, &count);
		XtGetValues(w, args, 1);
		return (int)count;
	    }
	    else if(sizeof(int) == res_assocs[i].size) {
		int count;
		XtSetArg(args[0], res_assocs[i].num_res, &count);
		XtGetValues(w, args, 1);
		return count;
	    }
	    XtAppWarning(XtWidgetToApplicationContext(w),
			 "Cannot compute liste size.");\
	}
    }
    return 0;
}


#define done(address, type)                               \
    {                                                   \
        if(toVal->addr)                                 \
        {                                               \
            if(toVal->size < sizeof(type))              \
            {                                           \
                toVal->size = sizeof(type);             \
                return( FALSE) ;                        \
            }                                           \
            else                                        \
            {   *((type *) (toVal->addr)) = *address;   \
            }                                           \
        }                                               \
        else                                            \
        {                                               \
            toVal->addr = (XPointer) address;           \
        }                                               \
        toVal->size = sizeof(type);                     \
    }



Boolean
CvtWidgetListToKlList(display, args, num_args, fromVal, toVal, destructor_data)
    Display *display;
    XrmValuePtr args;
    Cardinal *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *destructor_data;
{
    static KlList list = NULL;
    int n=0;
    Widget *widgets = *(Widget **) fromVal->addr;
    Widget item;
    int count;
    extern char *Tm_Resource;
    Widget w = *((Widget *) args[0].addr);
    
    count = GetListSize(w, Tm_Resource);
    list = KlListNMake(count);
    
    for(n = 0; n < count; n++) {
	item = widgets[n];
	list->list[n] = (KlO)KlWidgetMake(item);
	KlIncRef(list->list[n]);
    }
    

    done(&list, void *);


    return True;
}




Boolean
KlCvtCard32ToKlNumber(Display *dpy,
			  XrmValuePtr args,
			  Cardinal *num_args,
			  XrmValuePtr fromVal,
			  XrmValuePtr toVal,
			  XtPointer *destructor_data)
{
    static KlNumber number;
    CARD32 dimVal;
 
    dimVal = *(CARD32 *) (fromVal->addr);

    number = KlNumberMake();
    number->number = (Int) dimVal;
    done(&number, KlNumber);
    return True;
}


Boolean
KlCvtCard16ToKlNumber(Display *dpy,
			  XrmValuePtr args,
			  Cardinal *num_args,
			  XrmValuePtr fromVal,
			  XrmValuePtr toVal,
			  XtPointer *destructor_data)
{
    static KlNumber number;
    CARD16 dimVal;
 
    dimVal = *(CARD16 *) (fromVal->addr);

    number = KlNumberMake();
    number->number = (Int) dimVal;
    done(&number, KlNumber);
    return True;
}






#define SetCard16Converter(name)\
    XtSetTypeConverter(\
		name, XtRKlNumber,\
		KlCvtCard16ToKlNumber,\
		NULL,\
		0,\
		XtCacheNone,\
		NULL)

#define SetCard32Converter(name)\
    XtSetTypeConverter(\
		name, XtRKlNumber,\
		KlCvtCard32ToKlNumber,\
		NULL,\
		0,\
		XtCacheNone,\
		NULL)



#define SetNumberConverter(name, reptype)			\
    if(sizeof(name) == sizeof(CARD16)) {			\
	SetCard16Converter(reptype);				\
    }								\
    else if (sizeof(name) == sizeof(CARD32)) {			\
	SetCard32Converter(reptype);				\
    }								\
    else {							\
	XtAppWarning(app, "Cannot register converter.");\
    }

    
    
void
RegisterKloneConverters(XtAppContext app)
{
    XtConvertArgRec convert_arg;
    
    SetNumberConverter( Dimension, 	XmRDimension 	 	);
    SetNumberConverter( Dimension, 	XmRVerticalDimension 	);
    SetNumberConverter( Dimension, 	XmRHorizontalDimension 	);
    SetNumberConverter( Dimension, 	XmRBooleanDimension 	);
    SetNumberConverter( int, 		XmRInt 	 	 	);
    SetNumberConverter( unsigned int, 	XmRCardinal 	 	);
    SetNumberConverter( int, 		XmRHorizontalInt 	);
    SetNumberConverter( int, 		XmRVerticalInt 	 	);
    SetNumberConverter( int, 		XmRPosition 	 	);
    SetNumberConverter( int, 		XmRHorizontalPosition 	);
    SetNumberConverter( int, 		XmRVerticalPosition 	);
    SetNumberConverter( int, 		XmRTextPosition 	);
    SetNumberConverter( short, 		XmRShort 	 	);

    convert_arg.address_mode = XtWidgetBaseOffset;
    convert_arg.address_id = (XtPointer) XtOffsetOf(CoreRec, core.self);
    convert_arg.size = sizeof(CoreWidget);
    XtSetTypeConverter(XmRWidgetList,
		       XtRKlList,
		       CvtWidgetListToKlList,
		       &convert_arg,
		       1,
		       XtCacheNone,
		       NULL);

}



