#include <X11/Intrinsic.h>
#include "appall.h"


/**************************************************************** Prototypes */

/* setq symbols for all useful X Masks
 */
static void AppDefXEventMask ( void );
/* Wrapper: for XSelectInput(display, w, event_mask)
 */
static KlO AppXSelectInputKl ( KlO display, KlO window, KlO mask );
/* Wrapper: for XtDisplay( w )
 */
static KlO AppXDisplayOfWindowKl ( KlO window );
/* Wrapper: for XDrawLine(d, gc, x1, y1, x2, y2)
 */
static KlO AppXDrawLineKl ( int argc, KlO * argv );
/* Wrapper: for XSync(display, discard)
 */
static KlO AppXSyncKl ( KlO dpy );
/* Wrapper: for XSynchronize(display, discard)
 */
static KlO AppXSynchronizeKl ( KlO dpy, KlO onOff );

/******************************************************************** Bodies */



/* setq symbols for all useful X Masks
 */
static void
AppDefXEventMask(void)
{
    KlConstantMake("x:KeyPressMask", KlNumberMake(1L << 0));
    KlConstantMake("x:KeyReleasappask", KlNumberMake(1L << 1));
    KlConstantMake("x:ButtonPressMask", KlNumberMake(1L << 2));
    KlConstantMake("x:ButtonReleasappask", KlNumberMake(1L << 3));
    KlConstantMake("x:EnterWindowMask", KlNumberMake(1L << 4));
    KlConstantMake("x:LeaveWindowMask", KlNumberMake(1L << 5));
    KlConstantMake("x:PointerMotionMask", KlNumberMake(1L << 6));
    KlConstantMake("x:PointerMotionHintMask", KlNumberMake(1L << 7));
    KlConstantMake("x:Button1MotionMask", KlNumberMake(1L << 8));
    KlConstantMake("x:Button2MotionMask", KlNumberMake(1L << 9));
    KlConstantMake("x:Button3MotionMask", KlNumberMake(1L << 10));
    KlConstantMake("x:Button4MotionMask", KlNumberMake(1L << 11));
    KlConstantMake("x:Button5MotionMask", KlNumberMake(1L << 12));
    KlConstantMake("x:ButtonMotionMask", KlNumberMake(1L << 13));
    KlConstantMake("x:KeymapStatappask", KlNumberMake(1L << 14));
    KlConstantMake("x:Exposurappask", KlNumberMake(1L << 15));
    KlConstantMake("x:VisibilityChangappask", KlNumberMake(1L << 16));
    KlConstantMake("x:StructureNotifyMask", KlNumberMake(1L << 17));
    KlConstantMake("x:ResizeRedirectMask", KlNumberMake(1L << 18));
    KlConstantMake("x:SubstructureNotifyMask", KlNumberMake(1L << 19));
    KlConstantMake("x:SubstructureRedirectMask", KlNumberMake(1L << 20));
    KlConstantMake("x:FocusChangappask", KlNumberMake(1L << 21));
    KlConstantMake("x:PropertyChangappask", KlNumberMake(1L << 22));
    KlConstantMake("x:ColormapChangappask", KlNumberMake(1L << 23));
    KlConstantMake("x:OwnerGrabButtonMask", KlNumberMake(1L << 24));
    KlConstantMake("x:ShiftMask", KlNumberMake(1 << 0));
    KlConstantMake("x:LockMask", KlNumberMake(1 << 1));
    KlConstantMake("x:ControlMask", KlNumberMake(1 << 2));
    KlConstantMake("x:Mod1Mask", KlNumberMake(1 << 3));
    KlConstantMake("x:Mod2Mask", KlNumberMake(1 << 4));
    KlConstantMake("x:Mod3Mask", KlNumberMake(1 << 5));
    KlConstantMake("x:Mod4Mask", KlNumberMake(1 << 6));
    KlConstantMake("x:Mod5Mask", KlNumberMake(1 << 7));
    KlConstantMake("x:Button1Mask", KlNumberMake(1 << 8));
    KlConstantMake("x:Button2Mask", KlNumberMake(1 << 9));
    KlConstantMake("x:Button3Mask", KlNumberMake(1 << 10));
    KlConstantMake("x:Button4Mask", KlNumberMake(1 << 11));
    KlConstantMake("x:Button5Mask", KlNumberMake(1 << 12));
    KlConstantMake("x:CWEventMask", KlNumberMake(1L << 11));
    KlConstantMake("x:GCPlanappask", KlNumberMake(1L << 1));
    KlConstantMake("x:GCClipMask", KlNumberMake(1L << 19));
}


/* Wrapper: for XSelectInput(display, w, event_mask)
 */
static KlO
AppXSelectInputKl(KlO display,KlO window, KlO mask)
{
    KlO ro;
    long eventMask;
    Display *dpy;

    KlMustBeIntOrConstInt(display,1);
    KlMustBeIntOrConstInt(window,2);
    KlMustBeIntOrConstInt(mask,3);
    dpy=(KlNumToPtr(display));
    eventMask=NoEventMask; /*KlNumToInt(mask);*/
    printf("selectinput on window %d value:%d\n",KlNumToInt(window),eventMask);
    XSelectInput(KlNumToPtr(display), KlNumToInt(window), eventMask);
    return NIL;
}



/* Wrapper: for XDrawLine(d, gc, x1, y1, x2, y2)
 */
static KlO
AppXDrawLineKl(int argc, KlO * argv)
{
    int i;
    Display *dpy;
    Drawable d;
    GC gc;
    int x1, y1, x2, y2;

    if (argc != 7)
	return KlBadNumberOfArguments((char *) argc);
    for (i = 0; i < argc; i++)
	KlMustBeIntOrConstInt(argv[i], i + 1);
    dpy=KlNumToPtr(argv[0]);
    d = KlNumToInt(argv[1]);
    gc = KlNumToPtr(argv[2]);
    x1 = KlNumToInt(argv[3]);
    y1 = KlNumToInt(argv[4]);
    x2 = KlNumToInt(argv[5]);
    y2 = KlNumToInt(argv[6]);
    XDrawLine(dpy, d, gc, x1, y1, x2, y2);
    return NIL;
}


/* Wrapper: for XSync(display, discard)
 */
static KlO
AppXSyncKl(KlO dpy)
{
    KlMustBeIntOrConstInt(dpy, 0);
    XSync(KlNumToPtr(dpy),False);
    return NIL;
}

/* Wrapper: for XSynchronize(display, discard)
 */
static KlO
AppXSynchronizeKl(KlO dpy,KlO onOff)
{
    Bool oo;
    KlMustBeIntOrConstInt(dpy, 0);

    oo=KlTrueP(onOff);
    XSync(KlNumToPtr(dpy),oo);
    return NIL;
}


/* initialize the X module
 * . Create all the X classes
 * . Define all the X subroutines
 */
void
AppXInit(void)
{
    AppDefXEventMask();
    KlDeclareSubr(AppXSelectInputKl,"x:select-input",3);
    KlDeclareSubr(AppXSyncKl, "x:sync", 1);
    KlDeclareSubr(AppXSynchronizeKl, "x:synchronize", 2);
    KlDeclareSubr(AppXDrawLineKl, "x:draw-line", NARY);
}
