#ifndef APPKL_H
#define APPKL_H



/* TODO: actually there's no clash between AppIds (ptr) and CommId [0-256]
   but there may be so these func are here to do some conversions */
#define AppIdToCommId(id) (id)
#define CommIdToAppId(id) (id)

/* extract int field form KlNumber structure and pretend it's a pointer*/
#define KlNumToPtr(id) ((void*)(((KlNumber) id)->number))

/* extract int field form KlNumber structure */
#define KlNumToInt(num) ((int)(((KlNumber) num)->number))

/* extract char* field    form KlString structure */
#define KlStringToCharPtr(str) ((char*)(((KlString) str)->string))

/* check if it's an Id
   (actually AppIds are numbers pretending to be pointers :) */
#define KlMustBeId(id,pos) KlMustBeIntOrConstInt((id),(pos))


#define KlMustBeIntOrConstInt(obj,pos) \
    if(!KlIsAnInteger((KlO)obj)) {\
        obj = KlSend_eval((KlO)obj); \
        KlMustBeInteger((KlO)obj,pos);}

#define KlMustBeStringOrConstString(obj,pos) \
    if(!KlIsAString(obj)) {\
        obj = KlSend_eval(obj); \
        KlMustBeString(obj,pos);}


#define KlRetNilForZero(i) {KlO ro; if(i)KlIncRef(ro=(KlO)KlNumberMake(i));else ro=NIL;return ro;}

/**************************************************************** Prototypes */


/* */
KlO KlNumPointerMake ( void *p );

KlO KlForkKl ( void );

/* make a klone number and do its incref
 */
KlO KlNumberMakeIncRef ( long i );

/* make a klone number used later as pointer and do its incref
 */
KlO KlPtrMakeIncRef ( void *i );

/* make a klone string and do its incref
 */
KlO KlStringMakeIncRef ( char *s );

KlO KlSleepKl ( KlO sec );

/* Initialize all the Klone added functions for Klone
 */
void AppKlInit ( void );

void AppAllModulesInit(void);
/************************************************************ End Prototypes */


#endif					/* APPKL_H */
