#include <signal.h>
#include "appall.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */

/* */

KlO
KlNumPointerMake(void *p)
{
    KlO ro;

    ro = (KlO) KlNumberMake((long) p);
    KlIncRef(ro);
    return ro;
}

KlO
KlForkKl(void)
{
    int forkRes;

    forkRes = fork();
    if (!forkRes) {
	KlAtomSetq(KlIntern("*current-process-id*"), KlNumberMake(getpid()));
    }
    return KlNumberMakeIncRef(forkRes);
}


KlO
KlKillKl(KlO id)
{
    KlMustBeNumber(id, 0);

    return (KlO) KlNumberMake(kill(KlNumToInt(id), SIGTERM));
}

/* make a klone number and do its incref
 */
KlO
KlNumberMakeIncRef(long i)
{
    KlO ro;

    ro = (KlO) KlNumberMake(i);
    KlIncRef(ro);
    return ro;
}

/* make a klone number used later as pointer and do its incref
 */
KlO
KlPtrMakeIncRef(void *i)
{
    KlO ro;

    ro = (KlO) KlNumberMake((long) i);
    KlIncRef(ro);
    return ro;
}

/* make a klone string and do its incref
 */
KlO
KlStringMakeIncRef(char *s)
{
    KlO ro;

    ro = (KlO) KlStringMake(s);
    KlIncRef(ro);
    return ro;
}

KlO
KlSleepKl(KlO sec){
    KlMustBeIntOrConstInt(sec,0);
    sleep(KlNumToInt(sec));
}



/* Initialize all the Klone added functions for Klone
 */
void
AppKlInit(void)
{
    KlDeclareSubr(KlForkKl, "fork", 0);
    KlDeclareSubr(KlSleepKl, "sleep", 1);
    KlDeclareSubr(KlKillKl, "kill", 1);
}

void
AppAllModulesInit(void)
{
    AppCommInit();
    AppXInit();
    AppWidgetInit();
    AppKlInit();
    AppCallBackInit();
}
