#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/XmStrDefs.h>

#include "appall.h"
#include "appinterf.h"

struct CursorType {
    char *nameKl;
    int   type;
};

static struct CursorType tab[] = { 
    {"X_cursor", XC_X_cursor},
    {"arrow", XC_arrow},
    {"based_arrow_down", XC_based_arrow_down},
    {"based_arrow_up", XC_based_arrow_up},
    {"boat", XC_boat},
    {"bogosity", XC_bogosity},
    {"bottom_left_corner", XC_bottom_left_corner},
    {"bottom_right_corner", XC_bottom_right_corner},
    {"bottom_side", XC_bottom_side},
    {"bottom_tee", XC_bottom_tee},
    {"box_spiral", XC_box_spiral},
    {"center_ptr", XC_center_ptr},
    {"circle", XC_circle},
    {"clock", XC_clock},
    {"coffee_mug", XC_coffee_mug},
    {"cross", XC_cross},
    {"cross_reverse", XC_cross_reverse},
    {"crosshair", XC_crosshair},
    {"diamond_cross", XC_diamond_cross},
    {"dot", XC_dot},
    {"dotbox", XC_dotbox},
    {"double_arrow", XC_double_arrow},
    {"draft_large", XC_draft_large},
    {"draft_small", XC_draft_small},
    {"draped_box", XC_draped_box},
    {"exchange", XC_exchange},
    {"fleur", XC_fleur},
    {"gobbler", XC_gobbler},
    {"gumby", XC_gumby},
    {"hand1", XC_hand1},
    {"hand2", XC_hand2},
    {"heart", XC_heart},
    {"icon", XC_icon},
    {"iron_cross", XC_iron_cross},
    {"left_ptr", XC_left_ptr},
    {"left_side", XC_left_side},
    {"left_tee", XC_left_tee},
    {"leftbutton", XC_leftbutton},
    {"ll_angle", XC_ll_angle},
    {"lr_angle", XC_lr_angle},
    {"man", XC_man},
    {"middlebutton", XC_middlebutton},
    {"mouse", XC_mouse},
    {"pencil", XC_pencil},
    {"pirate", XC_pirate},
    {"plus", XC_plus},
    {"question_arrow", XC_question_arrow},
    {"right_ptr", XC_right_ptr},
    {"right_side", XC_right_side},
    {"right_tee", XC_right_tee},
    {"rightbutton", XC_rightbutton},
    {"rtl_logo", XC_rtl_logo},
    {"sailboat", XC_sailboat},
    {"sb_down_arrow", XC_sb_down_arrow},
    {"sb_h_double_arrow", XC_sb_h_double_arrow},
    {"sb_left_arrow", XC_sb_left_arrow},
    {"sb_right_arrow", XC_sb_right_arrow},
    {"sb_up_arrow", XC_sb_up_arrow},
    {"sb_v_double_arrow", XC_sb_v_double_arrow},
    {"shuttle", XC_shuttle},
    {"sizing", XC_sizing},
    {"spider", XC_spider},
    {"spraycan", XC_spraycan},
    {"star", XC_star},
    {"target", XC_target},
    {"tcross", XC_tcross},
    {"top_left_arrow", XC_top_left_arrow},
    {"top_left_corner", XC_top_left_corner},
    {"top_right_corner", XC_top_right_corner},
    {"top_side", XC_top_side},
    {"top_tee", XC_top_tee},
    {"trek", XC_trek},
    {"ul_angle", XC_ul_angle},
    {"umbrella", XC_umbrella},
    {"ur_angle", XC_ur_angle},
    {"watch", XC_watch},
    {"xterm", XC_xterm},
};

/* Function For CallBack queryForHelpKl
 */
void queryForHelp(Widget widget, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
    Widget help_widget;
    Cursor cursor;
    
    cursor = XCreateFontCursor(XtDisplay(widget), XC_hand2);
    if (help_widget = XmTrackingLocate(widget, cursor, False)) {
        cbs->reason = XmCR_HELP;
        XtCallCallbacks(help_widget, XmNhelpCallback, &cbs);
    }
    XFreeCursor(XtDisplay(widget), cursor);
}

/* Wrapper: for callback QueryForHelp(Widget, XtPointer, XtPointer)
 */
KlO queryForHelpKl(KlWidget klw)
{
    XmAnyCallbackStruct *cbs2;

    KlMustBeWidget(klw, 0);

    queryForHelp(klw->w, NULL, cbs2);
    return NIL;
}

/* Wrapper: for X Function : XListFonts
 */
KlList XListFontsKl(KlO dpy, KlO pattern, KlO maxNam) 
{
    char **fonts;
    int nfonts, i;
    KlList listKl;

    KlMustBeNumber(dpy, 0);
    KlMustBeString(pattern, 1);
    KlMustBeNumber(maxNam, 2);

    fonts = XListFonts(KlNumToPtr(dpy), KlStringToCharPtr(pattern), 
                       KlNumToInt(maxNam), &nfonts);
    listKl = KlListNMake(nfonts);
    KlIncRef(listKl);
    for (i=0; i<nfonts; i++) {
        listKl->list[i] = (KlO) KlStringMake(fonts[i]);
        KlIncRef(listKl->list[i]);
    }

    return listKl;
}

/* Affect a new style for the cursor in a specified widget.
 * 
 * Warning: must be used after widget's mapping.
 */
void defineCursor(Widget widget, char *cursorName)
{
    Cursor cursor;
    int i = 0, found;
    int nb_font = sizeof(tab)/sizeof(struct CursorType);

    if (cursorName!=NULL) {
        while ((i<nb_font)
               && ((found = strcmp(tab[i].nameKl, cursorName)) != 0)) i++;
        if (found == 0) {
            cursor = XCreateFontCursor(XtDisplay(widget), tab[i].type);
            XDefineCursor(XtDisplay(widget), XtWindow(widget), cursor);
        } else
            fprintf(stderr, "Warning: can't convert name to cursor\n");
    } else
        fprintf(stderr, "Warning: Invalid parameter !\n");
}

/* Wrapper: for defineCursor
 */
KlO defineCursorKl(KlWidget widget, KlO cursor)
{
    KlMustBeWidget(widget, 0);
    KlMustBeString(cursor, 1);

    defineCursor(widget->w, KlStringToCharPtr(cursor));

    return NIL;
}

/* Initialize all the Klone added functions for Klone
 */
void AppCallBackInit(void)
{
    KlDeclareSubr(queryForHelpKl, "query-for-help", 1);
    KlDeclareSubr(defineCursorKl, "cursor", 2);
    KlDeclareSubr(XListFontsKl, "x:list-fonts", 3);
}

