#ifndef APPCOMM_H
#define APPCOMM_H

/**************************************************************** Prototypes */


/* Wrapper for :int UAOpenLine(char *serverAdress, int portNum, int *pId);
 * opens a line of connection from this application to a server
 * the server is defined by it's address and a port number
 * an id is returned which identify this line. so message communications on
 * this line must use this id
 * if a less crude identification is needed by server this line may be named
 * (with a string). Use UARegisterNameKl to do so.
 * return: line id
 *
 * Warning! this function set the signal handler for SIG_PIPE to SIG_IGN
 */
KlO AppOpenLineKl(KlO serverAdress, KlO portNum);

/* Wrapper for :int UARegisterName(int id, char *lineName);
 * register name for this line
 * return: name or NIL if bad name
 */
KlO AppRegisterNameKl(KlO id, KlO lineName);

/* Wrapper for :int UACloseLine(int id);
 * close the line (id)
 * return: NIL
 */
KlO AppCloseLineKl(KlO id);

/* Wrapper for :int UACloseAllLines(void);
 * close all lines
 * remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 */
KlO UACloseAllLinesKl(void);

/* Wrapper for :int UASend(int id, void *msg, int len);
 * send a message (on at least store it in a buffer)
 * return: NIL
 */
KlO AppSendKl(KlO id, KlO msg);

/* Wrapper for :int UFlush(int id);
 * send all messages which may have been buffered (if any)
 * (ie flush actual packet (if needed))
 * return: NIL
 */
KlO AppFlushKl(KlO id);

/* Wrapper for :int UAPendingMsg(int id, int *pNbMsg);
 * how many messages are waiting for a read
 * return imediatly if messages are already queued
 * if no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer)
 * so may block a bit if correspondant is too busy.
 * return: number of waiting mesg
 */
KlO AppPendingMsgKl(KlO id);

/* Wrapper for :int UACheckPendingMsg(int id, int *pNbMsg);
 * how many messages are waiting for a read
 * checks for waiting packets abd return
 * nether blocks
 * return: number of waiting mesg
 */
KlO AppCheckPendingMsgKl(KlO id);

/* Wrapper for :int UAGetNextMsg(int id, char **ppMsg, int *pLen);
 * get next message
 * if no message in waiting queue :
 * - flush this line-end
 * - make periodics roundtrip to insure no messages are in buffer at the
 *   other line-end
 *   (so it's a blocking call)
 * return: got message
 */
KlO AppGetNextMsgKl(KlO id);

/* Wrapper for :int UAPeekNextMsg(int id, char **ppMsg, int *pLen);
 * peek next message (message is not removed from queue)
 * if no message in waiting queue :
 * - flush this line-end
 * - make periodics roundtrip to insure no messages are in buffer at the
 *   other line-end
 *   (so it's a blocking call)
 * return: NIL or message
 */
KlO AppPeekNextMsgKl(KlO id);

/* Wrapper for :int UAGetFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);
 * return (and remove) first matching message from queue
 * make no round trip so only messages which are already waiting are searched
 * (incorporate waiting packets before search)
 * head: string which must be the head of matching message
 * return: got message or NIL
 */
KlO AppGetFirstMatchingMsgKl(KlO id, KlO head);

/* Wrapper for :int UAPeekFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);
 *return (but don't remove) first matching message form queue
 * make no round trip so only messages which are already waiting are searched
 * (incorporate waiting packets before search)
 * head: string which must be the head of matching message
 * return: got message or NIL
 */
KlO AppPeekFirstMatchingMsgKl(KlO id, KlO head);

/* Wrapper for :int UANameToId(char *lineName);
 * return id associated to line nammed (lineName)
 * or NIL if no such line
 */
KlO AppNameToCommIdKl(KlO lineName);

/* Wrapper for :char *UAIdToName(int id);
 * return name of line identified by id
 * or NIL if no such line
 */
KlO AppIdToNameKl(KlO id);

/* init the Comm module
 */
void AppCommInit(void);

/************************************************************ End Prototypes */



#endif					/* APPCOMM_H */
