#include "appall.h"

#define AppCheckError(f) {int ACEStatus; if(ACEStatus=(f)){AppCommErrorKl(ACEStatus);return NIL;}}



/**************************************************************** Prototypes */


/******************************************************************** Bodies */


/* call KlError */
static int
AppCommErrorKl(int errCode)
{
    KlAtom klErr;

    klErr = KlErrorCodeMakeS(UErrCodeToErrString(errCode));
    KlError0(klErr);
    return errCode;
}



/* Wrapper for :int UAOpenLine(char *serverAdress, int portNum, int *pId);
 * opens a line of connection from this application to a server
 * the server is defined by it's address and a port number
 * an id is returned which identify this line. so message communications on
 * this line must use this id
 * if a less crude identification is needed by server this line may be named
 * (with a string). Use UARegisterNameKl to do so.
 * return: line id
 *
 * Warning! this function set the signal handler for SIG_PIPE to SIG_IGN
 */
KlO
AppOpenLineKl(KlO serverAdress, KlO portNum)
{
    KlO ro;
    int id;

    KlMustBeStringOrConstString(serverAdress, 1);
    KlMustBeIntOrConstInt(portNum, 2);
    AppCheckError(UAOpenLine(KlStringToCharPtr(serverAdress), KlNumToInt(portNum), &id));
    ro = (KlO) KlNumberMake(CommIdToAppId(id));
    return ro;
}

/* Wrapper for :int UARegisterName(int id, char *lineName);
 * register name for this line
 * return: name or NIL if bad name
 */
KlO
AppRegisterNameKl(KlO id, KlO lineName)
{
    KlO ro;

    KlMustBeIntOrConstInt(id, 1);
    KlMustBeStringOrConstString(lineName, 2);
    if (!UARegisterName(AppIdToCommId(KlNumToInt(id)), KlStringToCharPtr(lineName)))
	return lineName;
    else
	return NIL;			/* error bad name? */
}


/* Wrapper for :int UACloseLine(int id);
 * close the line (id)
 * return: NIL
 */
KlO
AppCloseLineKl(KlO id)
{
    KlMustBeId(id, 1);
    AppCheckError(UACloseLine(AppIdToCommId(KlNumToInt(id))));
    return NIL;
}

/* Wrapper for :int UACloseAllLines(void);
 * close all lines
 * remember to close all lines before end of
 * application or sockets won't be freed until some minutes
 */
KlO
UACloseAllLinesKl()
{
    return;
}


/* Wrapper for :int UASend(int id, void *msg, int len);
 * send a message (on at least store it in a buffer)
 * return: NIL
 */
KlO
AppSendKl(KlO id, KlO msg)
{
    KlMustBeId(id, 1);
    KlMustBeStringOrConstString(msg, 2);
    AppCheckError(UASend(AppIdToCommId(KlNumToInt(id)), KlStringToCharPtr(msg), strlen(KlStringToCharPtr(msg))));
    return NIL;
}

/* Wrapper for :int UAFlush(int id);
 * send all messages which may have been buffered in application line (id)
 * (if any)
 * (ie flush actual packet (if needed))
 * return: NIL
 */
KlO
AppFlushKl(KlO id)
{
    KlMustBeId(id, 1);
    AppCheckError(UAFlush(AppIdToCommId(KlNumToInt(id))));
    return NIL;
}

/* Wrapper for :int UAPendingMsg(int id, int *pNbMsg);
 * how many messages are waiting for a read
 * return imediatly if messages are already queued
 * if no message queued, flush buffer and wait for roundtrip
 * (ie be sure no message are kept in other line end buffer)
 * so may block a bit if correspondant is too busy.
 * return: number of waiting mesg
 */
KlO
AppPendingMsgKl(KlO id)
{
    KlO ro;
    int nbMsg;

    KlMustBeId(id, 1);
    AppCheckError(UAPendingMsg(AppIdToCommId(KlNumToInt(id)), &nbMsg));
    KlRetNilForZero(nbMsg);
}

/* Wrapper for :int UACheckPendingMsg(int id, int *pNbMsg);
 * how many messages are waiting for a read
 * checks for waiting packets abd return
 * nether blocks
 * return: number of waiting mesg
 */
KlO
AppCheckPendingMsgKl(KlO id)
{
    KlO ro;
    int nbMsg;

    KlMustBeId(id, 1);
    AppCheckError(UACheckPendingMsg(AppIdToCommId(KlNumToInt(id)), &nbMsg));
    KlRetNilForZero(nbMsg);
}

/* Wrapper for :int UAGetNextMsg(int id, char **ppMsg, int *pLen);
 * get next message
 * if no message in waiting queue :
 * - flush this line-end
 * - make periodics roundtrip to insure no messages are in buffer at the
 *   other line-end
 *   (so it's a blocking call)
 * return: got message
 */
KlO
AppGetNextMsgKl(KlO id)
{
    KlO ro;
    char *pMsg;
    int msgLen;

    KlMustBeId(id, 1);
    /* ?? TODO must return size too!!! */
    AppCheckError(UAGetNextMsg(AppIdToCommId(KlNumToInt(id)), &pMsg, &msgLen));
    ro = (KlO) KlStringMakeNoCopy(msgLen, pMsg);
    return ro;
}

/* Wrapper for :int UAPeekNextMsg(int id, char **ppMsg, int *pLen);
 * peek next message (message is not removed from queue)
 * if no message in waiting queue :
 * - flush this line-end
 * - make periodics roundtrip to insure no messages are in buffer at the
 *   other line-end
 *   (so it's a blocking call)
 * return: NIL or message
 */
KlO
AppPeekNextMsgKl(KlO id)
{
    KlO ro;
    char *pMsg;
    int msgLen;

    KlMustBeId(id, 1);
    /* ?? TODO must return size too!!! */
    AppCheckError(UAPeekNextMsg(AppIdToCommId(KlNumToInt(id)), &pMsg, &msgLen));
    if (msgLen) {
	ro = (KlO) KlStringMakeFromBytes(msgLen, pMsg);
	return ro;
    }
    else
	return NIL;
}

/* Wrapper for :int UAGetFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);
 * return (and remove) first matching message from queue
 * make no round trip so only messages which are already waiting are searched
 * (incorporate waiting packets before search)
 * head: string which must be the head of matching message
 * return: got message or NIL
 */
KlO
AppGetFirstMatchingMsgKl(KlO id, KlO head)
{
    KlO ro;
    char *pMsg;
    int msgLen;

    KlMustBeId(id, 1);
    KlMustBeStringOrConstString(head, 2);

    /* ?? TODO must return size too!!! */
    AppCheckError(UAGetFirstMatchingMsg(AppIdToCommId(KlNumToInt(id)), KlStringToCharPtr(head), &pMsg, &msgLen));
    if (msgLen) {
	ro = (KlO) KlStringMakeNoCopy(msgLen, pMsg);
	return ro;
    }
    else
	return NIL;
}

/* Wrapper for :int UAPeekFirstMatchingMsg(int id, char *head, char **ppMsg, int *pLen);
 *return (but don't remove) first matching message form queue
 * make no round trip so only messages which are already waiting are searched
 * (incorporate waiting packets before search)
 * head: string which must be the head of matching message
 * return: got message or NIL
 */
KlO
AppPeekFirstMatchingMsgKl(KlO id, KlO head)
{
    KlO ro;
    char *pMsg;
    int msgLen;

    KlMustBeId(id, 1);
    KlMustBeStringOrConstString(head, 2);
    /* ?? TODO must return size too!!! */
    AppCheckError(UAPeekFirstMatchingMsg(AppIdToCommId(KlNumToInt(id)), KlStringToCharPtr(head), &pMsg, &msgLen));
    if (msgLen) {
	ro = (KlO) KlStringMakeFromBytes(msgLen, pMsg);
	return ro;
    }
    else
	return NIL;
}


/* Wrapper for :int UANameToId(char *lineName);
 * return id associated to line nammed (lineName)
 * or NIL if no such line
 */
KlO
AppNameToCommIdKl(KlO lineName)
{
    KlO ro;
    int id;

    KlMustBeStringOrConstString(lineName, 1);

    id = UANameToId(KlStringToCharPtr(lineName));
    if (id >= 0) {
	ro = (KlO) KlNumberMake(id);
	return ro;
    }
    return NIL;
}

/* Wrapper for :char *UAIdToName(int id);
 * return name of line identified by id
 * or NIL if no such line
 */
KlO
AppIdToNameKl(KlO id)
{
    KlO ro;
    char *s;

    KlMustBeId(id, 1);
    s = UAIdToName(AppIdToCommId(KlNumToInt(id)));
    if (s) {
	ro = (KlO) KlStringMake(s);
	return ro;
    }
    else
	return NIL;
}


/* Wrapper for UAIdToFd: given a line id return its fd (socket number here) 
 * useful when need to do a select 
 */
KlO
AppIdToFdKl(KlO id){
    KlO ro;
    int fd;

    KlMustBeIntOrConstInt(id, 1);
    fd=UAIdToFd(AppIdToCommId(KlNumToInt(id)));
    if (fd>=0) {
	ro = (KlO) KlNumberMake(fd);
	return ro;
    }
    else
	return NIL;
}

/* Add handler on a line id
 * When running the XtAppMainLoop events incoming on this line
 * will trigger func with closure
 */
KlO
AppAddSocketHandlerKl(KlO id, KlO func, KlO closure){
    int fd;
    KlList list;
   
    extern void  KlExecuteInput(XtPointer client_data, int *source, XtInputId *id); /* ?? dirty hack, hope better in next release of klm klone emath with dynamic module extensions */
    fd=UAIdToFd(AppIdToCommId(KlNumToInt(id)));
    if (fd>=0) {
        list = KlListNMake(0);
        KlIncRef(list);
        KlListAppend(list, func);
        KlListAppend(list, closure);
        XtAppAddInput(klm.app,
                      fd,
                      (XtPointer)XtInputReadMask,
                      (XtInputCallbackProc)KlExecuteInput,
                      (XtPointer)list);
        return func;
    }
    else
	return NIL;
}    

/* init the Comm module
 */
void
AppCommInit(void)
{
    KlDeclareSubr(AppOpenLineKl, "open-line", 2);
    KlDeclareSubr(AppRegisterNameKl, "register-name", 2);
    KlDeclareSubr(AppCloseLineKl, "close-line", 1);
    KlDeclareSubr(AppSendKl, "send-msg", 2);
    KlDeclareSubr(AppFlushKl, "flush-line", 1);
    KlDeclareSubr(AppPendingMsgKl, "pending-msg", 1);
    KlDeclareSubr(AppCheckPendingMsgKl, "check-pending-msg", 1);
    KlDeclareSubr(AppGetNextMsgKl, "get-next-msg", 1);
    KlDeclareSubr(AppPeekNextMsgKl, "peek-next-msg", 1);
    KlDeclareSubr(AppGetFirstMatchingMsgKl, "get-first-matching-msg", 2);
    KlDeclareSubr(AppPeekFirstMatchingMsgKl, "peek-first-matching-msg", 2);
    KlDeclareSubr(AppNameToCommIdKl, "name-to-commid", 1);
    KlDeclareSubr(AppIdToNameKl, "commid-to-name", 1);
    KlDeclareSubr(AppIdToFdKl, "commid-to-fd", 1);
    KlDeclareSubr(AppAddSocketHandlerKl, "add-commid-handler", 3);
}
