#ifndef EMRES_H
#define EMRES_H

/* a rough guess of the number of converters (optimize hashtable access but not critical */
#define EM_NB_CONVERTERS_GUESS 20

#define XtRKlone "KLO"


/**************************************************************** Prototypes */


/* For all attributes names found in attrib list-of-attributes-name
 * Parse the xrdb to find their value.
 * Convert it depending on converter name find in this list.
 * Create an attribute with this name and value.
 *
 * Example:list-of-attributes-name -> ((background Pixel)
 *                                     (body-font FontStruct)
 *                                     (drag-cb KlO)).
 * applied for group 'zoom' (direct descendant of display group 'main')
 * in application 'test' (class Test)
 * parse resources like test.main.zoom.background
 *                      Test.main.zoom.background
 *                      test.main.zoom.body-font and so on
 * if a value has been found for background
 *   convert it to a pixel (using string-to-pixel)
 *   set attribute background on gate-node of group zoom with this pixel
 */
void EmXResToGroupAttrib ( EmGroup * pg );

/* Wrapper:
 * No effect becoz Xrd is not reparsed by Xt... ?? TODO
 */
KlO EmXResToGroupAttribKl ( KlO idgrp );

/* Init converters
 */
void EmResInit ( void );

/************************************************************ End Prototypes */



#endif					/* EMRES_H */
