#ifndef EMKL_H
#define EMKL_H


/* convert an EmId to a ptr (in fact EmIds are ptr but this may be useful
   if change happened  */
#ifdef DEBUG
#define EmIdToPtr(id) ((id)?((void*)(((KlNumber) id)->number)):UIWarning("EmIdToPtr", "Null pointer passed!\n"),NULL)
#else
#define EmIdToPtr(id) ((id)?((void*)(((KlNumber) id)->number)):NULL)
#endif

#define EmPtrToId(ptr) ((int)ptr)


/* convert an EmId to a Node ptr (in fact EmIds are ptr but this may be useful
   change is needed  */
#ifdef DEBUG
#define EmIdToNodePtr(id) ((id)?((EmNode*)(((KlNumber) id)->number)):NULL,UIWarning("EmIdToNodePtr", "Null pointer passed!\n"),NULL)
#else
#define EmIdToNodePtr(id) ((id)?((EmNode*)(((KlNumber) id)->number)):NULL)
#endif

#define EmNodePtrToId(ptr) (ptr)


/* TODO: actually there's no clash between EmIds (ptr) and CommId [0-256]
   but there may be so these func are here to do some conversions */
#define EmIdToCommId(id) (id)
#define CommIdToEmId(id) (id)


/* extract int field from KlNumber structure and pretend it's a pointer*/
#ifdef DEBUG
#define KlNumToPtr(num) ((num)?((void*)(((KlNumber) (num))->number)):(UIWarning("KlNumToPtr", "Null pointer passed!\n"),(void*)NULL))
#else
#define KlNumToPtr(num) ((num)?((void*)(((KlNumber) (num))->number)):(void*)NULL)
#endif


/* extract int field from KlNumber structure and cast to some kind of pointer*/
#ifdef DEBUG
#define KlNumToGrp(num) ((num)?((EmGroup*)(((KlNumber) (num))->number)):UIWarning("KlNumToGrp", "Null pointer passed!\n"),(void*)NULL)
#else
#define KlNumToGrp(num) ((num)?((EmGroup*)(((KlNumber) (num))->number)):(void*)NULL)
#endif

#ifdef DEBUG
#define KlNumToNode(num) ((num)?((EmNode*)(((KlNumber) (num))->number)):UIWarning("KlNumToNode", "Null pointer passed!\n"),(void*)NULL)
#else
#define KlNumToNode(num) ((num)?((EmNode*)(((KlNumber) (num))->number)):(void*)NULL)
#endif

#ifdef DEBUG
#define KlNumToEmGBox(num) ((num)?((EmGBox *)(((KlNumber) (num))->number)):UIWarning("KlNumToEmGBox", "Null pointer passed!\n"),(void*)NULL)
#else
#define KlNumToEmGBox(num) ((num)?((EmGBox *)(((KlNumber) (num))->number)):(void*)NULL)
#endif

#ifdef DEBUG
#define KlNumToWidget(num) ((num)?((Widget)(((KlNumber) (num))->number)):UIWarning("KlNumToWidget", "Null pointer passed!\n"),(Widget)(void*)NULL)
#else
#define KlNumToWidget(num) ((num)?((Widget)(((KlNumber) (num))->number)):(Widget)(void*)NULL)
#endif


/* extract int field from KlNumber structure */
/* ?? cast-> (int) dangerous becoz KlNumber->number is a long */
#ifdef DEBUG
#define KlNumToInt(num) ((num)?((int)(((KlNumber) (num))->number)):UIWarning("KlNumToInt", "Null pointer passed!\n"),0)
#else
#define KlNumToInt(num) ((int)(((KlNumber) (num))->number))
#endif

#ifdef DEBUG
#define KlNumToLong(num) ((num)?((long)(((KlNumber) (num))->number)):UIWarning("KlNumToLong", "Null pointer passed!\n"),0L)
#else
#define KlNumToLong(num) ((long)(((KlNumber) (num))->number))
#endif


/* extract char* field from KlString structure */
#ifdef DEBUG
#define KlStringToCharPtr(str) ((str)?((char*)(((KlString) (str))->string)):UIWarning("KlStringToCharPtr", "Null pointer passed!\n"),(void*)NULL)
#else
#define KlStringToCharPtr(str) ((str)?((char*)(((KlString) (str))->string)):(void*)NULL)
#endif



/* check if it's an Id
   (actually EmIds are numbers pretending to be pointers :) */
#define KlMustBeId(id,pos) KlMustBeIntOrConstInt((id),(pos))


#define KlMustBeIntOrConstInt(obj,pos) \
    if(!KlIsAnInteger((KlO)obj)) {\
        obj = KlSend_eval((KlO)obj); \
        KlMustBeInteger((KlO)obj,pos);}

#define KlMustBeStringOrConstString(obj,pos) \
    if(!KlIsAString(obj)) {\
        obj = KlSend_eval(obj); \
        KlMustBeString(obj,pos);}

/* ?? TODO: strange... check for use of incref here :( */
#define KlRetNilForZero(i) \
{\
   KlO ro; \
   if (i) { \
      KlIncRef(ro = (KlO)KlNumberMake(i)); \
   } \
   else { \
     ro=NIL; \
   } \
   return ro; \
}


#define KlPrintIfNonNull(obj) if(obj)KlPrint(obj);else printf("(NULL)");


/* ?? perhaps replace with a more complex id system... */
#define EmId void*


/**************************************************************** Prototypes */


/* Same as the std fork call but wrapped for klone
 */
KlO KlForkKl ( void );

/* Same as the std sleep call but wrapped for klone
 */
KlO KlSleepKl ( KlO sec );

/* Given a pointer return a KlNumber
 */
KlO KlNumPointerMake ( void *p );

/* Make a klone number and do its incref
 */
KlO KlNumberMakeIncRef ( long i );

/* Make a klone number used later as pointer and do its incref
 */
KlO KlPtrMakeIncRef ( void *i );

/* Make a klone string and do its incref
 */
KlO KlStringMakeIncRef ( char *s );

/* A wrapper to macro KlPrint (for easier call under debugger)
 */
void UKlPrint ( KlO o );

/* Is KlO true?
 * return False if KlO is () or 0 number or KlO is NULL, True otherwise
 * (klone take 0 to be true and only () to be false!)
 */
Bools KlCTrueP ( KlO obj );

/* Initialize all the Klone added functions for Klone
 */
void EmKlInit ( void );

/************************************************************ End Prototypes */

#endif					/* EMKL_H.h */
