#include "emall.h"


/**************************************************************** Prototypes */


/******************************************************************** Bodies */

/* Same as the std fork call but wrapped for klone
 */
KlO
KlForkKl(void)
{
    int forkRes;

    forkRes = fork();
    if (!forkRes) {
	KlAtomSetq(KlIntern("*current-process-id*"), KlNumberMake(getpid()));
    }
    return (KlO) KlNumberMake(forkRes);
}

/* Same as the std sleep call but wrapped for klone
 */
KlO
KlSleepKl(KlO sec)
{
    KlMustBeIntOrConstInt(sec, 0);
    sleep(KlNumToInt(sec));
    return sec;
}



/* Given a pointer return a KlNumber
 */
KlO
KlNumPointerMake(void *p)
{
    KlO ro;

    ro = (KlO) KlNumberMake((long) p);
    return ro;
}


/* Make a klone number and do its incref
 */
KlO
KlNumberMakeIncRef(long i)
{
    KlO ro;

    ro = (KlO) KlNumberMake(i);
    KlIncRef(ro);
    return ro;
}

/* Make a klone number used later as pointer and do its incref
 */
KlO
KlPtrMakeIncRef(void *i)
{
    KlO ro;

    ro = (KlO) KlNumberMake((long) i);
    KlIncRef(ro);
    return ro;
}

/* Make a klone string and do its incref
 */
KlO
KlStringMakeIncRef(char *s)
{
    KlO ro;

    ro = (KlO) KlStringMake(s);
    KlIncRef(ro);
    return ro;
}

/* A wrapper to macro KlPrint (for easier call under debugger)
 */
void
UKlPrint(KlO o)
{
    KlPrint(o);
    KlPrintf("\n", o);
}


/* Is KlO true?
 * return False if KlO is () or 0 number or KlO is NULL, True otherwise
 * (klone take 0 to be true and only () to be false!)
 */
Bools
KlCTrueP(KlO obj)
{
    return obj &&
	(KlTrueP(obj) && !(KlIsAnInteger(obj) && (((KlNumber) obj)->number == 0)));
}


/* Initialize all the Klone added functions for Klone
 */
void
EmKlInit(void)
{
    KlDeclareSubr(KlForkKl, "fork", 0);
    KlDeclareSubr(KlSleepKl, "sleep", 1);
}
