#ifndef EMGBOX_H
#define EMGBOX_H


/* max number of EmGBox cells that are kept in the garbage list */
/* more than that => they are freed */
#define EM_MAX_EMGBOX_GARBAGE 4096


/* divider of font height used to compute hline box height */
#define EM_GB_HLINE_VRATIO 6

/* some parametres for drawing symbols... */
#define EM_GB_ROOT_VCLEAR_RATIO 10
#define EM_GB_ROOT_HCLEAR_RATIO EM_GB_ROOT_VCLEAR_RATIO
#define EM_GB_ROOT_WSL_RATIO 2
#define EM_GB_ROOT_WBL_RATIO 2

#define EM_GB_MATRIX_VCLEAR_RATIO 2
#define EM_GB_MATRIX_HCLEAR_RATIO EM_GB_MATRIX_VCLEAR_RATIO

#define EM_GB_COLLEFT_VSTEP 30
#define EM_GB_COLLEFT_HSTEP 30


#define GBAscent(pgb) (pgb->h - pgb->descent)

typedef enum EmGBoxType {
    GBBad = 0,
    GBRow, GBRowCut, GBColLeft, GBColCenter,
    GBIndex, GBUp, GBDown,
    GBVector, GBMatrix,
    GBDiv, GBRoot,
    GBChar, GBSymb, GBRootSymb, GBHLine, GBMultSymb,
    GBUMinus,
    GBTemplate, GBContainer
}          EmGBoxType;

/* this box must be rebuild (correxponding EmNode or relevants attributes changed) */
#define EM_GB_REBUILD_MASK 1<<0

/* this box has a descendant that must be rebuild */
#define EM_GB_SONREBUILD_MASK 1<<1

/* this box must be refilled? (ie some of the nodes of the bounded tree have been modified (or created) */
#define EM_GB_REFILL_MASK 1<<2

/* this box must be redrawnfilled? (ie some of the nodes of the bounded tree have been modified (or created) */
#define EM_GB_REDRAW_MASK 1<<3

/* this box has been discarded (probably to reduce mem usage of EmGBox Tree) */
#define EM_GB_DISCARDED_MASK 1<<4

/* this box has been cached */
#define EM_GB_CACHED_MASK 1<<5

/* rebuild */
#define EmGBRebuildP(pgb) (((pgb)->stateMask) & EM_GB_REBUILD_MASK)
#define EmGBRebuildT(pgb) ((pgb)->stateMask |= EM_GB_REBUILD_MASK)
#define EmGBRebuildF(pgb) ((pgb)->stateMask &= ~EM_GB_REBUILD_MASK)

/* sonRebuild */
#define EmGBSonRebuildP(pgb) (((pgb)->stateMask) & EM_GB_SONREBUILD_MASK)
#define EmGBSonRebuildT(pgb) ((pgb)->stateMask |= EM_GB_SONREBUILD_MASK)
#define EmGBSonRebuildF(pgb) ((pgb)->stateMask &= ~EM_GB_SONREBUILD_MASK)

/* refill */
#define EmGBRefillP(pgb) (((pgb)->stateMask) & EM_GB_REFILL_MASK)
#define EmGBRefillT(pgb) ((pgb)->stateMask |= EM_GB_REFILL_MASK)
#define EmGBRefillF(pgb) ((pgb)->stateMask &= ~EM_GB_REFILL_MASK)

/* redraw */
#define EmGBRedrawP(pgb) (((pgb)->stateMask) & EM_GB_REDRAW_MASK)
#define EmGBRedrawT(pgb) ((pgb)->stateMask |= EM_GB_REDRAW_MASK)
#define EmGBRedrawF(pgb) ((pgb)->stateMask &= ~EM_GB_REDRAW_MASK)

/* discard */
#define EmGBDiscardedP(pgb) (((pgb)->stateMask) & EM_GB_DISCARDED_MASK)
#define EmGBDiscardedT(pgb) ((pgb)->stateMask |= EM_GB_DISCARDED_MASK)
#define EmGBDiscardedF(pgb) ((pgb)->stateMask &= ~EM_GB_DISCARDED_MASK)

/* cached */
#define EmGBCachedP(pgb) (((pgb)->stateMask) & EM_GB_CACHED_MASK)
#define EmGBCachedT(pgb) ((pgb)->stateMask |= EM_GB_CACHED_MASK)
#define EmGBCachedF(pgb) ((pgb)->stateMask &= ~EM_GB_CACHED_MASK)






/* does pgb bound the (x,y) point ? */
#define GbBoundP(pgb,cx,cy,xp,yp)\
                      (((cx) <= (xp)) && ((cx) + (pgb)->w) >= (xp) && \
                       ((cy) <= (yp)) && ((cy) + (pgb)->h) >= (yp))

/* is pgb bounded by the rectangle (ulx,uly,w,hk) ? */
#define GbBoundedP(pgb,cx,cy,ulx,uly,w,h)\
                      (((ulx) <= (cx)) && ((ulx) + (w) >= (cx) + (pgb)->w) && \
                       ((uly) <= (cy)) && ((uly) + (h) >= (cy) + (pgb)->h))



typedef enum EmFillConstraint {
    GBCBad = 0, GBCNone, GBCStrict, GBCHeightFixed
}                EmFillConstraint;

typedef struct EmGBox {
    EmGBoxType type;			/* type ... or what else ;) */
    Byte stateMask;			/* mask to store state of this box */
    unsigned short w, h;		/* size of this box */
    short descent;			/* base line position of thsi box */
    unsigned int x, y;			/* UL corner coords relative to the *
					 * virtual formula window */
    EmNode *pn;				/* which formula node is this box
					 * derived from */
    Pixmap pixmap;                      /* for pixmap caching */
    unsigned short pw, ph;		/* size of this pixmap (if not NULL)*/
    struct EmGBox *pFather;		/* father EmGBox, ie bounding box */
    struct EmGBox *pBrother;		/* first brother */
    struct EmGBox *pSon;		/* first son, ie first bounded box */
    void *pVal;				/* for a leaf EmGBox used to store a
					 * value used at fill or draw time */
}

       EmGBox;


/* type of function used to build the EmGBox tree */
typedef EmGBox *(*EmBuildEmGBoxFuncType) (EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* type of function used to fill the geometric fields of the EmGBox tree */
typedef void (*EmFillEmGBoxFuncType) (EmGroup * pg, EmGBox * pgb, EmFillConstraint constraint, int curx, int cury, Byte sizeLevel);

/* type of function used to draw the EmGBox tree */
typedef void (*EmDrawEmGBoxFuncType) (EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel);


/**************************************************************** Prototypes */


/* Return a EmGBox state (human redably ;)
 */
char * EmGBPrintState ( EmGBox * pgb );

/* Return a EmGBox type  (human redably ;)
 */
char * EmGBTypeToString ( EmGBox * pgb );

/* Check if father/son link is correct for this EmGBox and its father
 */
void EmCheckLinkGB ( EmGBox * pgb );

/* Print a short description of a given EmGBox
 */
void EmPrintGB ( EmGBox * pgb );

/* root of tree */
void EmPrintGBTree ( EmGBox * pgb );

/* Allocate a new EmGBox (not cleared).
 *
 * Allocation may be avoided if garbage list is not empty.
 */
EmGBox * EmAllocEmGBox ( void );

/* Free a EmGBox.
 *
 * Freed EmGBoxes are linked with their pSon pointers to form a garbage list.
 */
void EmFreeEmGBox ( EmGBox * pgb );

/* Node searched */
EmGBox * EmNodeToEmGBox ( EmGroup * pg, EmNode * pn );

/* EmGBox to link */
EmGBox * EmLinkEmGBoxToNode ( EmGroup * pg, EmNode * pn, EmGBox * pgb );

/* EmGBox to unlink */
void EmUnLinkEmGBoxToNode ( EmGroup * pg, EmNode * pn, EmGBox * rpgb );

/* height */
EmGBox * EmRectangleToEmGBoxes ( EmGroup * pg, EmGBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* This EmNode has been modified or added.
 * Set states of all boxes linked to this node and all their ancestors
 * to reflect this modification (that means doing this for all runing windows)
 */
void EmUpdateGBoxStateAdd ( EmNode * pn );

/* This EmNode is to be unlinked from it's father
 * Set states of all boxes linked to this node and all their ancestors
 * to reflect this modification (that means doing this for all runing windows)
 */
void EmUpdateGBoxStateRemove ( EmNode * pn );

/* This EmNode has been modified
 * Set states of all boxes linked to this node and all their ancestors
 * to reflect this modification (that means doing this for all runing windows)
 */
void EmUpdateGBoxStateSet ( EmNode * pn );

/* Wrapper:
 */
KlO EmRectangleToEmGBoxesKl ( int argc, KlO * argv );

/* height */
EmGBox * EmRectangleToBigestEmGBox ( EmGroup * pg, EmGBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* Wrapper:
 */
KlO EmRectangleToBigestEmGBoxKl ( int argc, KlO * argv );

/* height */
EmGBox * EmRectangleToHighestEmGBox ( EmGroup * pg, EmGBox * pgb, int vx, int vy, int ulx, int uly, int w, int h );

/* Wrapper:
 */
KlO EmRectangleToHighestEmGBoxKl ( int argc, KlO * argv );

/* point ygiven in virtual window
		    coordinates */
EmGBox * EmCoordToEmGBox ( EmGroup * pg, EmGBox * pgb, int vx, int vy, int x, int y );

/* Wrapper:
 */
KlO EmCoordToEmGBoxKl ( int argc, KlO * argv );

/* Searched EmGBox */
EmNode * EmGBoxToNode ( EmGroup * pg, EmGBox * pgb );

/* Searched EmGBox */
KlO EmGBoxToNodeKl ( KlO pg, KlO pgb );

/* Node to fill */
void EmGBoxFDA ( EmGroup * pg, EmNode * pn );

/* init the EmGBox module
 */
void EmGBoxInit ( void );

/************************************************************ End Prototypes */



#endif					/* EMGBOX_H */
