#include "emall.h"

/**************************************************************** Prototypes */

/* static function not documented...
 */
static void EmDrawEmGBoxHLine ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
/* static function not documented...
 */
static void EmDrawEmGBoxRootSymb ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
/* static function not documented...
 */
static void EmDrawEmGBoxMultSymb ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
/* static function not documented...
 */
static void EmDrawEmGBoxChar ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
/* static function not documented...
 */
static void EmDrawEmGBoxSymb ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
/* static function not documented...
 */
static void EmDrawEmGBoxTemplate ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );
static void EmDrawEmGBoxShape ( EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel );

/******************************************************************** Bodies */


/* create or update pixmap for dbl buffering
 */
void
EmSetDbBuffer(EmGroup * pg, EmGBox * pgb, int fulx, int fuly)
{
    EmNode *pn;

    pn = KlNumToPtr(EmAGetC(pg, EmGateNode, "*root-node*"));
    pgtd->bgc = EmFontToGC(pg,
			  EmFindFont(pg, pn, "body", 0),
			  (Pixel) KlNumToPtr(EmAGetC(pg, pn, "background")),
			  (Pixel) KlNumToPtr(EmAGetC(pg, pn, "background")));
    pgtd->fgc = EmFontToGC(pg,
			  EmFindFont(pg, pn, "body", 0),
			  (Pixel) KlNumToPtr(EmAGetC(pg, pn, "foreground")),
			  (Pixel) KlNumToPtr(EmAGetC(pg, pn, "foreground")));
    if (!pgtd->dbPixmap) {
	pgtd->dbPixmap = XCreatePixmap(pgtd->dpy, pgtd->win, pgtd->wh, pgtd->ww, DefaultDepth(pgtd->dpy, DefaultScreen(pgtd->dpy)));
    }

    XFillRectangle(pgtd->dpy, pgtd->dbPixmap, pgtd->bgc, 0, 0, pgtd->ww, pgtd->wh);
}

/* copy pixmap to window (thus doing dbl buffering)
 */
void
EmCopyDbBuffer(EmGroup * pg, EmGBox * pgb, int fulx, int fuly)
{
    XCopyArea(pgtd->dpy, pgtd->dbPixmap, pgtd->win, pgtd->bgc, 0, 0, pgtd->ww, pgtd->wh, 0, 0);
}

/* static function not documented...
 */
static void
EmDrawEmGBoxHLine(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc, fulx + pgb->x, fuly + GBAscent(pgb) + pgb->y, fulx + pgb->x + pgb->w, fuly + GBAscent(pgb) + pgb->y);
}

/* static function not documented...
 */
static void
EmDrawEmGBoxRootSymb(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    XFontStruct *pfs;
    int fontHeight, wsl, wbl;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    fontHeight = pfs->ascent + pfs->descent;
    wsl = fontHeight / EM_GB_ROOT_WSL_RATIO;
    wbl = fontHeight / EM_GB_ROOT_WBL_RATIO;
    /* small line (\) */
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
	      fulx + pgb->x, fuly + pgb->y + pgb->h - wsl,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h);
    /* big line (/) */
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y);
    /* straight hat (_) */
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y,
	      fulx + pgb->x + pgb->w, fuly + pgb->y);

};


/* static function not documented...
 */
static void
EmDrawEmGBoxMultSymb(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    int sz;

    sz = UMin(pgb->w - 4, pgb->h - pgb->descent - 4);
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2);
    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2);
}

/* static function not documented...
 */
static void
EmDrawEmGBoxChar(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;

    gc = EmFontToGC(pg, 
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
		(Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "body-font-color")),
		    (Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(pgtd->dpy, (Drawable) pgtd->dbPixmap, gc,
		(unsigned int) (fulx + pgb->x),
		(unsigned int) (fuly + pgb->y + pgb->h - pgb->descent),
		(char *) pgb->pVal, 1);

}

/* static function not documented...
 */
static void
EmDrawEmGBoxSymb(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    UNIW;
}

/* static function not documented...
 */
static void
EmDrawEmGBoxTemplate(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;
    char c = '?';

    gc = EmFontToGC(pg, 
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
		(Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "body-font-color")),
		    (Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(pgtd->dpy, pgtd->dbPixmap, gc,
		fulx + pgb->x, fuly + pgb->y + pgb->h - pgb->descent,
		&c, 1);
}


static void
EmDrawEmGBoxShape(EmGroup * pg, EmGBox * pgb, int fulx, int fuly, Byte sizeLevel)
{
    EmNode *pn;

    pn = pgb->pn;
    if (KlCTrueP(EmAGetC(pg, pn, "draw-box"))) {
	XDrawRectangle(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc, fulx + pgb->x - pgtd->wx, fuly + pgb->y - pgtd->wy, pgb->w, pgb->h);
    }

    if (KlCTrueP(EmAGetC(pg, pn, "draw-diag"))) {
	if (pgb->pn->nbsn)
	    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
		      fulx + pgb->x - pgtd->wx,
		      fuly + pgb->y - pgtd->wy,
		      fulx + pgb->x + pgb->w - pgtd->wx,
		      fuly + pgb->y + pgb->h - pgtd->wy);
	else
	    XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
		      fulx + pgb->x + pgb->w - pgtd->wx,
		      fuly + pgb->y - pgtd->wy,
		      fulx + pgb->x - pgtd->wx,
		      fuly + pgb->y + pgb->h - pgtd->wy);
    }
}

/* Draw this box and all its descendants.
 * ?? TODO: add yield
 */
int
EmDrawEmGBox(EmGroup * pg /* Group to use for attribs */ ,
	     EmGBox * pgb /* Root box for filled tree */ ,
	     int fulx		/* X position of the ul corner of
					 * father-box relatively to the
     	     	     	     	     	         virtual formula window */ ,
	     int fuly		/* Y position of the ul corner of
					 * father-box relatively to the
     	     	     	     	     	         virtual formula window */ ,
	     Byte sizeLevel)
{
    EmDrawEmGBoxFuncType pf;
    EmNode *pn, *pcn;
    EmGBox *pgbs;
    int cost = 0;

#ifdef TEST_THREAD_OVERFLOW
    EmTpCheckStackOverflow(pgtd);
#endif
    /* box is not in the output window */
    if ((fuly > pgtd->wy + pgtd->wh) || ((fuly + pgb->h) < pgtd->wy) ||
	(fulx > pgtd->wx + pgtd->ww) || (fulx + pgb->w < pgtd->wx))
	return 0;
    if (EmGBCachedP(pgb)) {
	XCopyArea(pgtd->dpy, pgb->pixmap, pgtd->dbPixmap, pgtd->bgc, 0, 0, pgb->w, pgb->h, fulx + pgb->x, fuly + pgb->y);
	return 1;
    }

    pn = pgb->pn;
    EmDrawEmGBoxShape(pg, pgb, fulx, fuly, sizeLevel);
    pcn = KlNumToPtr(EmAGetC(pg, (EmNode *) NULL, "*current-node*"));;
    if (pn == pcn) {
	XDrawLine(pgtd->dpy, pgtd->dbPixmap, pgtd->fgc,
		fulx + pgb->x + pgb->w - pgtd->wx, fuly + pgb->y - pgtd->wy,
		  fulx + pgb->x + pgb->w - pgtd->wx, fuly + pgb->y + pgb->h - pgtd->wy);
        cost -= 100;
    }

    switch (pgb->type) {
	/* leafs */
    case GBSymb:
    case GBChar:
    case GBHLine:
    case GBRootSymb:
    case GBMultSymb:
    case GBTemplate:{
	    {
		char funcName[MAX_CHAR_TMP];

		strcpy(funcName, "GB");
		strcat(funcName, EmGBTypeToString(pgb));
		strcat(funcName, "Draw");
		pf = KlNumToPtr(EmAGetC(pg, pn, funcName));
	    }
	    if (!pf)
		UIError("EmDrawEmGBox", "unknown gbox-type %d", pgb->type);

	    pf(pg, pgb, fulx, fuly, sizeLevel);
	    cost = 1;
	}
	/* non leaf boxes with size change */
    case GBUp:
    case GBDown:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		cost += EmDrawEmGBox(pg, pgbs, fulx + pgb->x, fuly + pgb->y, sizeLevel + 1);

		pgbs = pgbs->pBrother;
	    }
	    break;
	}
	/* non leaf boxes without size change */
    case GBContainer:
    case GBUMinus:
    case GBIndex:
    case GBRow:
    case GBRowCut:
    case GBColLeft:
    case GBColCenter:
    case GBDiv:
    case GBRoot:
    case GBVector:
    case GBMatrix:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		cost += EmDrawEmGBox(pg, pgbs, fulx + pgb->x, fuly + pgb->y, sizeLevel);
		pgbs = pgbs->pBrother;
	    }
	    break;
	}
    case GBBad:
    default:
	UIError("EmDrawEmGBox", "unknown node-type %d", pgb->type);
    }

    if (cost >= 5) {
	if (pgb->pixmap) {		/* ??TODO check pixmap size before free */
	    XFreePixmap(pgtd->dpy, pgb->pixmap);
	}
	pgb->pixmap = XCreatePixmap(pgtd->dpy, pgtd->win, pgb->w, pgb->w, DefaultDepth(pgtd->dpy, DefaultScreen(pgtd->dpy)));
	pgb->pw = pgb->w;
	pgb->ph = pgb->h;
	XCopyArea(pgtd->dpy, pgtd->dbPixmap, pgb->pixmap, pgtd->bgc, fulx + pgb->x, fuly + pgb->y, pgb->w, pgb->h, 0, 0);
	EmGBCachedT(pgb);
	cost = 1;
    }
    return cost;
}


/* Must fill all default attributes concerning drawing of GBoxes.
 */
void
EmGBoxFDADraw(EmGroup * pg /* Group to fill */ ,
	      EmNode * pn /* Node to fill */ )
{

    EmASetC(pg, pn, "GBCharDraw", KlNumPointerMake(EmDrawEmGBoxChar));
    EmASetC(pg, pn, "GBHLineDraw", KlNumPointerMake(EmDrawEmGBoxHLine));
    EmASetC(pg, pn, "GBSymbDraw", KlNumPointerMake(EmDrawEmGBoxSymb));
    EmASetC(pg, pn, "GBRootSymbDraw", KlNumPointerMake(EmDrawEmGBoxRootSymb));
    EmASetC(pg, pn, "GBMultSymbDraw", KlNumPointerMake(EmDrawEmGBoxMultSymb));
    EmASetC(pg, pn, "GBTemplateDraw", KlNumPointerMake(EmDrawEmGBoxTemplate));
}
