#include "emall.h"
#define EM_NB_FC_GUESS 40

typedef struct EmFontColor {
    XFontStruct *pfs;
    Pixel fg, bg;
}           EmFontColor;


static AssocTable *EmAtFontColorGc;


/**************************************************************** Prototypes */

/* hash a EmFontColor variable
 */
static int EmFontColorHash ( EmFontColor * pfc, int sz );
/* sort two EmFontColor variables
 */
static int EmFontColorOrd ( EmFontColor * pfc1, EmFontColor * pfc2 );

/******************************************************************** Bodies */
/* */

/* hash a EmFontColor variable
 */
static int
EmFontColorHash(EmFontColor * pfc, int sz)
{
    return (pfc->fg + pfc->bg + (long) (pfc->pfs)) % sz;
}

/* sort two EmFontColor variables
 */
static int
EmFontColorOrd(EmFontColor * pfc1, EmFontColor * pfc2)
{
    if (pfc1->fg != pfc2->fg)
	return pfc1->fg - pfc2->fg;
    if (pfc1->bg != pfc2->bg)
	return pfc1->bg - pfc2->bg;
    if (pfc1->pfs != pfc2->pfs)
	return pfc1->pfs - pfc2->pfs;
    return 0;
}

/* given a XFontStruct and two colors (fg & bg) return a GC
 * returned gc are cached
 */
GC
EmFontToGC(EmGroup * pg, XFontStruct * pfs, Pixel fg, Pixel bg)
{
    GC gc;
    EmFontColor fc, *pfc;
    XGCValues gcv;

    fc.pfs = pfs;
    fc.fg = fg;
    fc.bg = bg;
    if ((gc = atSearch(EmAtFontColorGc, &fc)))
	return gc;
    else {
	gcv.font = (pfs)->fid;
	gcv.foreground = fg;
	gcv.background = bg;   
        gcv.graphics_exposures = False;
	gc = XCreateGC(pgtd->dpy, pgtd->win,
		       GCForeground | GCBackground | GCFont| GCGraphicsExposures, &gcv);
	pfc = UNew(EmFontColor);
	*pfc = fc;
	atInsert(EmAtFontColorGc, pfc, gc, False);
	return gc;
    }
}


/* Init the cache module.
 */
void
EmCacheInit(void)
{
    EmAtFontColorGc = atCreate(EM_NB_FC_GUESS, EmFontColorHash, EmFontColorOrd, nullFunc, nullFunc, printVoid, printVoid);
}
