#ifndef EMATTRIB_H
#define EMATTRIB_H
#include "emall.h"


#define MAX_ATTRIB_NAME_LEN 63
#define EmAttribVal KlO

/* attributes are 3uples. group+node+name */
typedef struct EmAttrib {
    EmGroup *pgrp;			/* attribute's group */
    EmNode *pnod;			/* attribute's node */
    char *pname;			/* attribute's name */
    EmAttribVal val;			/* attribute's value */
}

         EmAttrib;

#define EmFillAttrib(a,pgrp,pnod,pname) (a,a.pgrp=pgrp,a.pnod=pnod,a.pname=pname)
#define EmFreeAttribVal(val) (KlDecRef((KlO)val))


#ifdef DEBUG
#define AtoInt(val) (((KlNumber) val)->number,KlMustBeNumber(val))
#define AtoDouble(val) (((KlReal) val)->real,KlMustBeReal(val))
#define AtoString(val) (((KlString) val)->string,KlMustBeStringOrConstString(val))
#else
#define AtoInt(val) (((KlNumber) val)->number)
#define AtoDouble(val) (((KlReal) val)->real)
#define AtoString(val) (((KlString) val)->string)
#endif					/* DEBUG */


/**************************************************************** Prototypes */


/* Free an attrib
 */
void EmFreeAttrib ( EmAttrib * pa );

/* if not 0 print value of attribute */
void EmPrintAttrib ( EmAttrib * pa, int printVal );

/* Get value of an attrib but only if it is localy set
 * (ie no inheritance using node/group trees)
 */
KlO EmAGetLocal ( EmAttrib * pa );

/* name of the searched attribute */
KlO EmAGetLocalC ( EmGroup * pg, EmNode * pn, char *pname );

/* Wrapper:
 */
KlO EmAGetLocalKl ( KlO grp, KlO nod, KlO name );

/* Get an attribute.
 * if attribute is not set on the requested node search through all
 * the ancestors of this node.
 * if didn't sucess then restart on this node but using the father of
 * requested group (and so on until rootGroup is reached or attribute is found)
 * return NULL if nothing found
 */
KlO EmAGet ( EmAttrib * pa );

/* name of the searched attribute */
KlO EmAGetC ( EmGroup * pg, EmNode * pn, char *pname );

/* name of the searched attribute */
KlO EmAGetKl ( KlO grp, KlO nod, KlO name );

/* Set an attribute value (but localy, don't overwrite instance of same
 * attribute which may be set lower in the inheritance tree
 */
void EmASetLocal ( EmAttrib * pa, KlO val );

/* value to set */
KlO EmASetLocalKl ( KlO grp, KlO nod, KlO name, KlO val );

/* value to set */
void EmASetLocalC ( EmGroup * pg, EmNode * pn, char *pname, KlO val );

/* value to set */
void EmASet ( EmAttrib * pa, KlO val );

/* value to set */
KlO EmASetKl ( KlO grp, KlO nod, KlO name, KlO val );

/* See EmASet. this version is designed to be called from C.
 */
void EmASetC ( EmGroup * pg, EmNode * pn, char *pname, KlO val );

/* Unset an attribute (but localy, don't unset instance of same
 * attribute which may be set lower in the inheritance tree
 */
void EmAUnsetLocal ( EmAttrib * pa );

/* name of the searched attribute */
KlO EmAUnsetLocalKl ( KlO grp, KlO nod, KlO name );

/* attribute to set */
void EmAUnset ( EmAttrib * pa );

/* name of the searched attribute */
KlO EmAUnsetKl ( KlO grp, KlO nod, KlO name );

/* Initialize all attributes functions for Klone
 */
void EmAttribInit ( void );

/************************************************************ End Prototypes */

#endif					/* EMATTRIB_H */
