
#ifndef EMTP_H
#define EMTP_H

#include <setjmp.h>
#include <X11/Xlib.h>
#include "util.h"
#include "emgroup.h"
#include "emtree.h"
#ifndef BUILD_MAN
#include "qt.h"
#endif

/* events and messages are tested roughly each 0.1s */
/* (if yield is done thru EmTpTickYield() */
#define EMTP_TICK_LENGHT 1000000

/* do a Yield only if at least EMTP_TICK_LENGHT microseconds */
/* remember that EmTpYield do some check on events before yielding */
#define EmTpTickedYield(self) if(EmTpTick){EmTpRestartTick();EmTpYield(self);}
/*#define EmTpTickedYield(self) if(EmTpTick){EmTpRestartTick();EmTpYield(self);}else{printf("------------select avoided\n");}*/

/* alignment must be a power of 2. */
#define EM_TP_STKALIGN(sp, alignment) \
                     ((void *)(((qt_word_t)(sp)) & ~((alignment)-1)))

/* size of a thread stack...
 * warning this must be big enough to support full stack activity
 * without overflow
 */
#define EM_TP_STKSIZE (0x10000)

/* priority */
#define EM_TP_MAX_PRI_QUEUE 2
#define EM_TP_STARTPRIORITY 1
#define EM_TP_FOCUSPRIORITY 2
#define EM_TP_NORMALPRIORITY 1
#define EM_TP_SLEEPINGPRIORITY 0

/* states of a thread */
#define EM_TP_DYING 0
#define EM_TP_RUNING 1


/* macros for restarting a thread */
#define EmTpRestartPoint(pt)  setjmp(pt->restartPoint)
#define EmTpNeedRefresh(pt,Bools)  pt->needRefresh=Bools
#define EmTpRestartRefresh(pt,Bools)  pt->needRefresh=pt->restartRefresh=Bools



/****************************************************************** typedefs */

/* struct linked to each thread (each window in fact)
 * it has a private part used only thru C functions
 * and a public Klone accessile part
 */
typedef struct Td {
    /* used only for threads */
    qt_t *sp;				/* stack pointer for this thread */
    void *sto;				/* stack for this thread */
    int stackSize;			/* stack size */
    char status;			/* state of this thread */
    /* (runing, dying...) */
    int priority;			/* priority of refresh in this window */
    jmp_buf restartPoint;		/* where to restart */
    /* for Klone */
    KlO self;				/* access to this struct thru a Klone
					 * object */
    /* flag for refresh conditions */
    Bools restartRefresh;		/* restart the refresh in this
					 * window? */
    Bools needRefresh;			/* a refresh to start or to continue
					 * in this window? */

    /* fields used for graphic display */
    EmGroup *pg;			/* the group to use for display */
    EmNode *pn;				/* the formula to display */
    Display *dpy;
    Widget wid;
    Window win;
    unsigned int wx, wy;		/* current position of ul corner of
					 * win in the virtual formula window */
    unsigned int wh, ww;		/* current dimension of window */
    GC fgc, bgc;			/* fore and background gcs */
}

   Td;

/* a kind of thread generic function */
typedef void (TpF) (struct Td * ptd);


extern int EmTpTick;

extern KlStructClass KlTdClass;


/**************************************************************** Prototypes */


/* Print thread data
 */
void EmTpTdPrint(Td * ptd);

/* ?? just for debuging
 */
void EmTpRunQAPrint(void);

/* This window will be redrawn as soon as possible (during next scheduling)
 */
KlO EmTpRestartRefreshKl(KlO winId);

/* This window is beeing drawn... so call its refreshing thread during
 * next scheduling
 */
KlO EmTpNeedRefreshKl(KlO winId);

/* Change the priority of a thread
 */
void EmTpChangePriority(Td * ptd, int newPri);

/* Wrapper: for EmTpChangePriority(Td * ptd, int newPri)
 */
KlO EmTpChangePriorityKl(KlO winId, KlO newPri);

/* Restart the tick alarm
 */
void EmTpRestartTick(void);

/* refresh function */
Td *EmTpCreateNewThread(TpF * rf);

/* Check for thread stack overflow
 * print warning on stderr if more than 80% of stack are filled
 */
void EmTpCheckStackOverflow(Td * self);

/* The current thread stops running but stays runable.
 * It is an error to call `EmTpYield' before `EmTpSchedule*'
 * is called or after `EmTpStart' returns.
 */
void EmTpYield(Td * self);

/* Like `EmTpYield' but the thread is discarded. Any intermediate
 * state is lost. The thread can also terminate by simply
 * returning.
 */
void EmTpAbort(Td * old);

/* When one or more threads are created by the main thread,
 * the system goes multithread when this is called.
 * the threads are runned until refresh is done
 * or some events occurs (needs to be handled)
 * they are run in priority order
 */
void EmTpScheduleHighest(void);

/* Wrapper:
 */
KlO EmTpScheduleHighestKl(void);

/* if not NULL return if there's a
		       message (X or line) */
int EmWaitForNewEvents(Bools blocking, int *pIsMsg);

/* Wrapper:
 */
KlO EmWaitForNewEventsKl(void);

/* Initialize the EmTp module
 *
 * Create the Td classe.
 * Define all the Tp subroutines
 */
void EmTpInit(void);

/* A raw draw function
 * ?? TODO: dbl buffering
 */
void EmDrawWindow(Td * ptd);

/************************************************************ End Prototypes */

#endif					/* EMTP_H */
