#ifndef EMRECORD_H
#define EMRECORD_H

/* a rough guess of the number of displays used by en application (optimize hashtable access but not critical */
#define EM_NB_DISPLAY_GUESS 20

/* a rough guess of the number of windows used by en application (optimize hashtable access but not critical */
#define EM_NB_WINDOW_GUESS 100

/* only one AppContext per emath-server so keep it in this global variable
 * to avoid useless call overhead due to klone->C->klone conversion
 */
extern XtAppContext EmAppContext;

/* the real application root-group... one per server */
extern EmGroup *EmAppRootGroup;

/* List of groups for runing windows */
extern List *EmListOfWindows;

static String
       EmFallbacks[] =
{NULL};


/**************************************************************** Prototypes */


/* class of application to record */
void *EmRecordApp(char *appName, char *appClass);

/* Wrapper for : EmRecordApp(char *appName, char *appClass)
 */
KlO EmRecordAppKl(KlO appName, KlO appClass);

/* can be used to retrieve this
		    display using EmNameToDisplay */
void *EmRecordDisplay(char *dpyAddress, char *name);

/* Wrapper for : EmRecordDisplay(char *dpyAddress, char *name)
 */
KlO EmRecordDisplayKl(KlO dpyAddress, KlO name);

/* initial state in the translation */
void *EmRecordWindow(EmGroup * fatherGroup, Window win, char *name, KlO emtt, KlO initialState);

/* Wrapper
 */
KlO EmRecordWindowKl(KlO fg, KlO win, KlO name, KlO emtt, KlO initialState);

/* the window */
void EmAddFormulaToWindow(EmNode * pn, Window win);

/* Wrapper:
 */
KlO EmAddFormulaToWindowKl(KlO pn, KlO win);

/* searched widget */
EmGroup *EmWidToGroup(Widget wid);

/* searched widget */
KlO EmWidToGroupKl(KlO wid);

/* Return the group linked to a display
 */
EmGroup *EmDisplayToGroup(Display * dpy);

/* searched name */
Display *EmNameToDisplay(char *name);

/* searched display */
char *EmDisplayToName(Display * dpy);

/* searched name */
void *EmNameToWidget(char *name);

/* searched name */
KlO EmNameToWidgetKl(KlO name);

/* searched window */
Td *EmWinToThread(Window win);

/* searched window */
EmGroup *EmWinToGroup(Window win);

/* searched widget */
KlO EmWinToGroupKl(KlO win);

/* searched widget */
Td *EmWidToThread(Widget wid);

/* unmanage a window... mark thread as dying... next schedule will sweep it
 * TODO modify... is that useful? probably... so must check
 */
void EmTpUnmanageWindow(Window win);

/* Wrapper: for void EmTpUnmanageWindow(Window win);
 * unmanage a window... mark thread as dying... next schedule will sweep it
 */
KlO EmTpUnmanageWindowKl(KlO winId);

/* init record module
 */
void EmRecordInit(void);

/************************************************************ End Prototypes */



#endif					/* EMRECORD_H */
