#include "emall.h"
/**************************************************************** Prototypes */


/******************************************************************** Bodies */


/* Given the left part of a link
 *
 * Return:  The right one if any
 */
void *
EmLinkGetRight(EmLinkTable * plt, void *pLeft)
{
    return atSearch(plt->patLeftToRight, pLeft);
}

/* Given the right part of a link
 *
 * Return: The left one if any
 */
void *
EmLinkGetLeft(EmLinkTable * plt, void *pRight)
{
    return atSearch(plt->patRightToLeft, pRight);
}


/* Make a link between left and right
 *
 * Warning: links using these parts are losts.
 * Use EmAlreadyLinked to check it before
 *
 * Example: link("a","b"); link("z","b") getleft("b")->"z"; "a" is lost
 */
void
EmLinkMake(EmLinkTable * plt, void *pLeft, void *pRight)
{
    atInsert(plt->patLeftToRight, pLeft, pRight, True);
    atInsert(plt->patRightToLeft, pRight, pLeft, True);
}

/* Check if one of these two parts is already linked in plt
 */
Bools
EmAlreadyLinked(EmLinkTable * plt, void *pLeft, void *pRight)
{
    return (atSearch(plt->patLeftToRight, pLeft) || atSearch(plt->patRightToLeft, pRight)) ? True : False;
}

/* Build a link table
 */
EmLinkTable *
EmLinkTableCreate(int size		/* A rough guess on the total number
					 * of link which will be stored in
		      these table */ ,
		  EmLinkCmpFunc compareLeft	/* Function to apply between
						 * two left parts to
						 * determine their order
						 * (must return an int
						 * negative nul or positive
		      depending on order). */ ,
		  EmLinkCmpFunc compareRight	/* See compareLeft. The same
		      but on the right part. */ ,
		  EmLinkHashFunc hashLeft	/* Function applied to find
						 * the hash index for the
		      left part of a link */ ,
		  EmLinkHashFunc hashRight	/* SeehashLeft. The same but
		      on the right part. */ ,
		  EmLinkFreeFunc freeLeft	/* Function applied to free
		      left part of a link. */ ,
		  EmLinkFreeFunc freeRight	/* See freeLeft. The same but
		      on the right part. */ ,
		  EmLinkPrintFunc printLeft	/* function applied to print
		      left part of a link. */ ,
		  EmLinkPrintFunc printRight	/* See printLeft. The same
		      but on the right part. */ )
{
    EmLinkTable *plt;

    plt = UNew(EmLinkTable);
    plt->patLeftToRight = atCreate(size, hashLeft, compareLeft, freeLeft, freeRight, printLeft, printRight);
    plt->patRightToLeft = atCreate(size, hashRight, compareRight, freeRight, freeLeft, printRight, printLeft);
    return plt;
}

/* Free a EmLinkTable (call free on its two hashtables)
 */
void
EmLinkTableFree(EmLinkTable * plt)
{
    atFree(plt->patLeftToRight, False);
    atFree(plt->patRightToLeft, True);
    UFree(plt);
}
