#ifndef EMGROUP_H
#define EMGROUP_H
#include "emlink.h"


/* a rough guess of the number of group used by en application (optimize hashtable access but not critical */
#define EM_NB_GROUP_GUESS 20

typedef struct EmGroup {
    Byte nbsc;				/* number of son cells in aps (some
					 * may be empty) */
    Byte nbs;				/* number of sons in aps */
    struct EmGroup *pf;			/* father */
    struct EmGroup **aps;		/* array of sons */
}       EmGroup;


/* the root group of the whole tree of groups */
/* ?? this sould not be modified by user (put a write protection in group and attrib functions?) */
extern EmGroup *EmRootGroup;

/* the link table for group and names */
extern EmLinkTable *EmGroupNameLink;



/**************************************************************** Prototypes */


/* Convenience func to create the rootGroup
 */
void EmCreateRootGroup(void);

/* Create a new group
 *
 * Return: address of this group which is used as Id for this group
 */
EmGroup *EmCreateGroup(char *name, EmGroup * pfgrp);

/* Wrapper: for EmCreateGroup()
 */
KlO EmCreateGroupKl(KlO name, KlO idfgrp);

/* Print a group
 */
void EmPrintGroup(EmGroup * pgrp);

/* Wrapper:
 */
KlO EmPrintGroupKl(KlO idgrp);

/* Print a group tree given its root
 */
void EmPrintGroupTree(EmGroup * pgrp);

/* Wrapper:
 */
KlO EmPrintGroupTreeKl(KlO idgrp);

/* Return: the father of a group pgrp.
 */
EmGroup *EmFatherGroup(EmGroup * pgrp);

/* Wrapper: for EmFatherGroup(EmGroup * pn)
 */
KlO EmFatherGroupKl(KlO idgrp);

/* Return: the number of sons of this group (pgrp).
 */
int EmNbSonGroups(EmGroup * pgrp);

/* Wrapper: for EmNbSonGroups(EmGroup * pgrp)
 */
KlO EmNbSonGroupsKl(KlO idgrp);

/* Return: the Nth (n) son of a group (pgrp).
 */
EmGroup *EmNthSonGroup(EmGroup * pgrp, int n);

/* Wrapper: for EmNthSonGroup(EmGroup * pgrp, int n)
 */
KlO EmNthSonGroupKl(KlO idgrp, KlO num);

/* Build the string containing the tree path of this group
 * (without the application root-group).
 * Caller responsible for freeing returned string
 */
char *EmGroupPath(EmGroup * pgrp);

/* Initialize all group manipulating functions for Klone.
 */
void EmGroupInit(void);

/************************************************************ End Prototypes */

#endif					/* EMGROUP_H */
