#include "emall.h"

/* chunk of reallocation for new son groups */
#define EM_REALLOC_SZ_GROUP 4


/* the root group of the whole tree of groups */
/* ?? this sould not be modified by user (put a write protection in group and attrib functions?) */
EmGroup *EmRootGroup;

/* the link table for group and names */
EmLinkTable *EmGroupNameLink;

/**************************************************************** Prototypes */

/* static function not documented...
 */
static void EmPrintGroupTreeAux(EmGroup * pgrp, int level);

/* the son */
static int EmAddSonGroup(EmGroup * pgrp, EmGroup * ps);

/******************************************************************** Bodies */

/* Convenience func to create the rootGroup
 */
void
EmCreateRootGroup(void)
{
    EmRootGroup = EmCreateGroup("rootGroup", (EmGroup *) NULL);
    EmASetC(EmRootGroup, EmGateNode, "*root-group*", KlPtrMakeIncRef(EmRootGroup));
}


/* Create a new group
 *
 * Return: address of this group which is used as Id for this group
 */
EmGroup *
EmCreateGroup(char *name, EmGroup * pfgrp)
{
    EmGroup *pgrp;
    KlO ro;

    pgrp = UNew(EmGroup);
    name = UStrDup(name);		/* make a copy to avoid Klone Gc ;) */
    if (!pfgrp)				/* this is the root-group so must
					 * retrieve its name from NULL
					 * pointer too */
	EmLinkMake(EmGroupNameLink, NULL, name);

    EmLinkMake(EmGroupNameLink, pgrp, name);	/* ?? check if name not
						 * already used */
    pgrp->nbsc = 0;
    pgrp->nbs = 0;
    pgrp->pf = NULL;
    pgrp->aps = NULL;
    if (pfgrp) {
	EmAddSonGroup(pfgrp, pgrp);
    }
#ifdef TRACE_GROUP_CREATE
    EmPrintGroupTree(EmRootGroup);
#endif
    ro = (KlO) KlStringMake(name);
    KlIncRef(ro);
    EmASetC(pgrp, EmGateNode, "*group-name*", ro);
    return pgrp;
}


/* Wrapper: for EmCreateGroup()
 */
KlO
EmCreateGroupKl(KlO name, KlO idfgrp)
{
    KlO ro;

    KlMustBeStringOrConstString(name, 0);
    KlMustBeIntOrConstInt(idfgrp, 1);

    ro = (KlO) KlNumberMake(EmPtrToId(EmCreateGroup(KlStringToCharPtr(name), KlNumToGrp(idfgrp))));
    return ro;
}

/* Print a group
 */
void
EmPrintGroup(EmGroup * pgrp)
{
    if (!pgrp) {
	printf("group to print is NULL!\n");
	return;
    }
    printf("%s (%d sons)", (char *) EmLinkGetRight(EmGroupNameLink, pgrp), pgrp->nbs);
}


/* Wrapper:
 */
KlO
EmPrintGroupKl(KlO idgrp)
{
    KlMustBeIntOrConstInt(idgrp, 0);
    EmPrintGroup(KlNumToGrp(idgrp));
    return idgrp;
}

/* static function not documented...
 */
static void
EmPrintGroupTreeAux(EmGroup * pgrp, int level)
{
    int i, l;

    if (!pgrp) {
	printf("group to print is NULL!\n");
	return;
    }
    EmPrintGroup(pgrp);
    putchar('\n');
    for (i = 0; i < pgrp->nbs; i++) {
	for (l = 0; l < 2 * level; l++)
	    putchar(' ');
	putchar('-');
	putchar('>');
	EmPrintGroupTreeAux(pgrp->aps[i], level + 1);
    }
}


/* Print a group tree given its root
 */
void
EmPrintGroupTree(EmGroup * pgrp)
{
    if (!pgrp) {
	printf("group to print is NULL!\n");
	return;
    }
    EmPrintGroupTreeAux(pgrp, 1);
}

/* Wrapper:
 */
KlO
EmPrintGroupTreeKl(KlO idgrp)
{
    KlMustBeIntOrConstInt(idgrp, 0);
    EmPrintGroupTree(KlNumToGrp(idgrp));
    return idgrp;
}

/* Return: the father of a group pgrp.
 */
EmGroup *
EmFatherGroup(EmGroup * pgrp)
{
    return pgrp->pf;
}

/* Wrapper: for EmFatherGroup(EmGroup * pn)
 */
KlO
EmFatherGroupKl(KlO idgrp)
{
    KlO ro;
    int idf;

    KlMustBeIntOrConstInt(idgrp, 0);
    idf = EmPtrToId(EmFatherGroup(KlNumToGrp(idgrp)));
    if (idf) {
	ro = (KlO) KlNumberMake(idf);
	return ro;
    }
    else
	return NIL;
}

/* Return: the number of sons of this group (pgrp).
 */
int
EmNbSonGroups(EmGroup * pgrp)
{
    return pgrp->nbs;
}

/* Wrapper: for EmNbSonGroups(EmGroup * pgrp)
 */
KlO
EmNbSonGroupsKl(KlO idgrp)
{
    KlO ro;

    KlMustBeIntOrConstInt(idgrp, 0);
    ro = (KlO) KlNumberMake(EmNbSonGroups(KlNumToGrp(idgrp)));
    return ro;
}

/* Return: the Nth (n) son of a group (pgrp).
 */
EmGroup *
EmNthSonGroup(EmGroup * pgrp, int n)
{
    assert(n < pgrp->nbs);
    return pgrp->aps[n];
}

/* Wrapper: for EmNthSonGroup(EmGroup * pgrp, int n)
 */
KlO
EmNthSonGroupKl(KlO idgrp, KlO num)
{
    KlO ro;
    int ids;

    KlMustBeIntOrConstInt(idgrp, 0);
    KlMustBeIntOrConstInt(num, 1);
    ids = EmPtrToId(EmNthSonGroup(KlNumToGrp(idgrp), KlNumToInt(num)));
    if (ids) {
	ro = (KlO) KlNumberMake(ids);
	return ro;
    }
    else
	return NIL;
}


/* Add a Son (ps) to a Group (pgrp)
 *
 * ps is added as last son of pgrp
 *
 * Return: rank of son
 */
static int
EmAddSonGroup(EmGroup * pgrp /* the group */ ,
	      EmGroup * ps /* the son */ )
{
    if (pgrp->nbs == pgrp->nbsc) {
	pgrp->nbsc += EM_REALLOC_SZ_GROUP;
	pgrp->aps = URealloc(pgrp->aps, pgrp->nbsc);
    }
    pgrp->aps[pgrp->nbs++] = ps;
    ps->pf = pgrp;

    return pgrp->nbs;
}


/* Build the string containing the tree path of this group
 * (without the application root-group).
 * Caller responsible for freeing returned string
 */
char *
EmGroupPath(EmGroup * pgrp)
{
    char *gn, *p, c;
    char tmp[MAX_CHAR_TMP];
    int l, la;

    tmp[0] = '\0';
    while (pgrp->pf) {
	gn = EmLinkGetRight(EmGroupNameLink, pgrp);	/* get the new level */
	la = strlen(gn) + 1;		/* +1 for . */
	l = strlen(tmp);
	for (p = tmp + l; p >= tmp; p--)/* shift path to make room for the
					 * new level */
	    *(p + la) = *p;
	c = *tmp;			/* keep the char that will be erased
					 * by the \0 of strcpy */
	strcpy(tmp, gn);
	*(tmp + la) = c;		/* put it back */
	*(tmp + la - 1) = '.';		/* put the '.' which is the level
					 * separator */
	pgrp = pgrp->pf;
    }
    tmp[strlen(tmp) - 1] = '\0';	/* erase the last '.' which  is
					 * useless */
    return UStrDup(tmp);
}


/* Initialize all group manipulating functions for Klone.
 */
void
EmGroupInit(void)
{
    EmGroupNameLink =
    EmLinkTableCreate(EM_NB_GROUP_GUESS,
		      (EmLinkCmpFunc) ordVoid,
		      (EmLinkCmpFunc) ordString,
		      (EmLinkHashFunc) hashVoid,
		      (EmLinkHashFunc) hashString,
		      (EmLinkFreeFunc) nullFunc,
		      (EmLinkFreeFunc) UFree,
		      (EmLinkPrintFunc) printVoid,
		      (EmLinkPrintFunc) printString);

    EmCreateRootGroup();

    KlDeclareSubr(EmCreateGroupKl, "create-group", 2);
    KlDeclareSubr(EmFatherGroupKl, "father-group", 1);
    KlDeclareSubr(EmPrintGroupKl, "print-group", 1);
    KlDeclareSubr(EmPrintGroupTreeKl, "print-group-tree", 1);
    KlDeclareSubr(EmNbSonGroupsKl, "nb-sons-group", 1);
    KlDeclareSubr(EmNthSonGroupKl, "nth-son-group", 2);
}
