#include "emall.h"

/**************************************************************** Prototypes */

/* static function not documented...
 */
static void EmDrawEmGBoxHLine(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void EmDrawEmGBoxRootSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void EmDrawEmGBoxMultSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void EmDrawEmGBoxChar(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void EmDrawEmGBoxSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/* static function not documented...
 */
static void EmDrawEmGBoxTemplate(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);
static void EmDrawEmGBoxShape(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel);

/******************************************************************** Bodies */

/* static function not documented...
 */
static void
EmDrawEmGBoxHLine(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc, fulx + pgb->x, fuly + GBAscent(pgb) + pgb->y, fulx + pgb->x + pgb->w, fuly + GBAscent(pgb) + pgb->y);
}

/* static function not documented...
 */
static void
EmDrawEmGBoxRootSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    XFontStruct *pfs;
    int fontHeight, wsl, wbl;

    pfs = EmFindFont(pg, pgb->pn, "body", sizeLevel);
    fontHeight = pfs->ascent + pfs->descent;
    wsl = fontHeight / EM_GB_ROOT_WSL_RATIO;
    wbl = fontHeight / EM_GB_ROOT_WBL_RATIO;
    /* small line (\) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x, fuly + pgb->y + pgb->h - wsl,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h);
    /* big line (/) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + wsl, fuly + pgb->y + pgb->h,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y);
    /* straight hat (_) */
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + wsl + wbl, fuly + pgb->y,
	      fulx + pgb->x + pgb->w, fuly + pgb->y);

};


/* static function not documented...
 */
static void
EmDrawEmGBoxMultSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    int sz;

    sz = UMin(pgb->w - 4, pgb->h - pgb->descent - 4);
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2);
    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
	      fulx + pgb->x + (pgb->w - sz) / 2,
	      fuly + pgb->y + (pgb->h + sz) / 2,
	      fulx + pgb->x + (pgb->w + sz) / 2,
	      fuly + pgb->y + (pgb->h - sz) / 2);
}

/* static function not documented...
 */
static void
EmDrawEmGBoxChar(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;

    gc = EmFontToGC(pg, ptd,
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
		(Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "body-font-color")),
		    (Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(ptd->dpy, (Drawable) ptd->win, gc,
		(unsigned int) (fulx + pgb->x),
		(unsigned int) (fuly + pgb->y + pgb->h - pgb->descent),
		(char *) pgb->pVal, 1);

}

/* static function not documented...
 */
static void
EmDrawEmGBoxSymb(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    UNIW;
}

/* static function not documented...
 */
static void
EmDrawEmGBoxTemplate(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    GC gc;
    char c = '?';

    gc = EmFontToGC(pg, ptd,
		    EmFindFont(pg, pgb->pn, "body", sizeLevel),
		(Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "body-font-color")),
		    (Pixel) KlNumToInt(EmAGetC(pg, pgb->pn, "background")));
    XDrawString(ptd->dpy, ptd->win, gc,
		fulx + pgb->x, fuly + pgb->y + pgb->h - pgb->descent,
		&c, 1);
}


static void
EmDrawEmGBoxShape(EmGroup * pg, EmGBox * pgb, Td * ptd, int fulx, int fuly, Byte sizeLevel)
{
    EmNode *pn;

    pn = pgb->pn;
    if (KlCTrueP(EmAGetC(pg, pn, "draw-box"))) {
	XDrawRectangle(ptd->dpy, ptd->win, ptd->fgc, fulx + pgb->x - ptd->wx, fuly + pgb->y - ptd->wy, pgb->w, pgb->h);
    }

    if (KlCTrueP(EmAGetC(pg, pn, "draw-diag"))) {
	if (pgb->pn->nbsn)
	    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		      fulx + pgb->x - ptd->wx,
		      fuly + pgb->y - ptd->wy,
		      fulx + pgb->x + pgb->w - ptd->wx,
		      fuly + pgb->y + pgb->h - ptd->wy);
	else
	    XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		      fulx + pgb->x + pgb->w - ptd->wx,
		      fuly + pgb->y - ptd->wy,
		      fulx + pgb->x - ptd->wx,
		      fuly + pgb->y + pgb->h - ptd->wy);
    }
}

/* Draw this box and all its descendants.
 * ?? TODO: add yield
 */
void
EmDrawEmGBox(EmGroup * pg /* Group to use for attribs */ ,
	     EmGBox * pgb /* Root box for filled tree */ ,
	     Td * ptd /* Pointer to window/thread structure */ ,
	     int fulx			/* X position of the ul corner of
					 * father-box relatively to the
	         virtual formula window */ ,
	     int fuly			/* Y position of the ul corner of
					 * father-box relatively to the
	         virtual formula window */ ,
	     Byte sizeLevel)
{
    EmDrawEmGBoxFuncType pf;
    EmNode *pn, *pcn;
    EmGBox *pgbs;

#ifdef TEST_THREAD_OVERFLOW
    EmTpCheckStackOverflow(ptd);
#endif
    /* box is not in the output window */
    if ((fuly > ptd->wy + ptd->wh) || ((fuly + pgb->h) < ptd->wy) ||
	(fulx > ptd->wx + ptd->ww) || (fulx + pgb->w < ptd->wx))
	return;

    pn = pgb->pn;

    EmDrawEmGBoxShape(pg, pgb, ptd, fulx, fuly, sizeLevel);

    pcn = KlNumToPtr(EmAGetC(pg, (EmNode *) NULL, "*current-node*"));;
    if (pn == pcn) {
	XDrawLine(ptd->dpy, ptd->win, ptd->fgc,
		  fulx + pgb->x + pgb->w - ptd->wx, fuly + pgb->y - ptd->wy,
	fulx + pgb->x + pgb->w - ptd->wx, fuly + pgb->y + pgb->h - ptd->wy);
    }

    switch (pgb->type) {
	/* leafs */
    case GBSymb:
    case GBChar:
    case GBHLine:
    case GBRootSymb:
    case GBMultSymb:
    case GBTemplate:{
	    {
		char funcName[MAX_CHAR_TMP];

		strcpy(funcName, "GB");
		strcat(funcName, EmGBTypeToString(pgb));
		strcat(funcName, "Draw");
		pf = KlNumToPtr(EmAGetC(pg, pn, funcName));
	    }
	    if (!pf)
		UIError("EmDrawEmGBox", "unknown gbox-type %d", pgb->type);

	    pf(pg, pgb, ptd, fulx, fuly, sizeLevel);
	    break;
	}
	/* non leaf boxes with size change */
    case GBUp:
    case GBDown:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		EmDrawEmGBox(pg, pgbs, ptd, fulx + pgb->x, fuly + pgb->y, sizeLevel + 1);
		pgbs = pgbs->pBrother;
	    }
	    break;
	}
	/* non leaf boxes without size change */
    case GBContainer:
    case GBUMinus:
    case GBIndex:
    case GBRow:
    case GBRowCut:
    case GBColLeft:
    case GBColCenter:
    case GBDiv:
    case GBRoot:
    case GBVector:
    case GBMatrix:{
	    pgbs = pgb->pSon;
	    while (pgbs) {
		EmDrawEmGBox(pg, pgbs, ptd, fulx + pgb->x, fuly + pgb->y, sizeLevel);
		pgbs = pgbs->pBrother;
	    }
	    break;
	}
    case GBBad:
    default:
	UIError("EmDrawEmGBox", "unknown node-type %d", pgb->type);
    }
}


/* Must fill all default attributes concerning drawing of GBoxes.
 */
void
EmGBoxFDADraw(EmGroup * pg /* Group to fill */ ,
	      EmNode * pn /* Node to fill */ )
{

    EmASetC(pg, pn, "GBCharDraw", KlNumPointerMake(EmDrawEmGBoxChar));
    EmASetC(pg, pn, "GBHLineDraw", KlNumPointerMake(EmDrawEmGBoxHLine));
    EmASetC(pg, pn, "GBSymbDraw", KlNumPointerMake(EmDrawEmGBoxSymb));
    EmASetC(pg, pn, "GBRootSymbDraw", KlNumPointerMake(EmDrawEmGBoxRootSymb));
    EmASetC(pg, pn, "GBMultSymbDraw", KlNumPointerMake(EmDrawEmGBoxMultSymb));
    EmASetC(pg, pn, "GBTemplateDraw", KlNumPointerMake(EmDrawEmGBoxTemplate));
}
