#include "emall.h"

static EmGBox *emGBoxGarbage = NULL;
static int gemGBoxGarbageCount = 0;



/**************************************************************** Prototypes */

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxLeaf(EmGroup * pg, EmNode * pn, EmGBox * pgb, EmGBoxType type, void *pVal);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxString(EmGroup * pg, EmNode * pn, EmGBox * pgb);
static EmGBox *EmBuildEmGBoxSymbol(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static char *EmBuildEmGBoxNodeToString(EmGroup * pg, EmNode * pn);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxBinOPRow(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* Like EmBuildEmGBoxBinOPRow but check for UMinus son to disable + symb
 */
static EmGBox *EmBuildEmGBoxPlusRow(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* Like EmBuildEmGBoxBinOPRow but check for implicit mult
 */
static EmGBox *EmBuildEmGBoxMultRow(EmGroup * pg, EmNode * pn, EmGBox * pgb);
static EmGBox *EmBuildEmGBoxUMinus(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxBinDiv(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxEq(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxIndex(EmGroup * pg, EmNode * pn, EmGBox * pgb, EmGBoxType type);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxExp(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxInd(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxRoot(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxFunc(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxColumn(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxVector(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxMatrix(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxParenth(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxTemplate(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/* static function not documented...
 */
static EmGBox *EmBuildEmGBoxContainer(EmGroup * pg, EmNode * pn, EmGBox * pgb);

/******************************************************************** Bodies */


/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxLeaf(EmGroup * pg, EmNode * pn, EmGBox * pgb, EmGBoxType type, void *pVal)
{
    if (!pgb)
	pgb = EmAllocEmGBox();
    pgb->type = type;
    pgb->pn = pn;
    pgb->pVal = pVal;
    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxString(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *charGb, *charTmpGb;
    char *p;
    int i;
    EmNode *psn;

    pgb->type = GBRow;

    charTmpGb = NULL;
    for (i = EmNbSonNodes(pn); i > 0; i--) {
	psn = EmNthSonNode(pn, i - 1);
	if (psn->nbsn) {
	    /* special case of String son of String */
	    charGb = EmBuildEmGBox(pg, psn);
	}
	else {
	    p = KlStringToCharPtr(psn->d.value);
	    charGb = EmBuildEmGBoxLeaf(pg, psn, NULL, GBChar, p);
	}
	charGb->pBrother = charTmpGb;
	charTmpGb = charGb;
	charGb->pFather = pgb;
    }
    pgb->pSon = charGb;

    return pgb;
}

static EmGBox *
EmBuildEmGBoxSymbol(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    return EmBuildEmGBoxLeaf(pg, pn, pgb, GBChar, "Z");
}

/* static function not documented...
 */
static char *
EmBuildEmGBoxNodeToString(EmGroup * pg, EmNode * pn)
{
    switch (pn->type) {
	case NTUMinus:
	return "-";
    case NTPlus:
	return "+";
    case NTMult:
	return "*";
    case NTDiv:
	return "/";
    case NTEq:
	return "=";
    default:
	return "@";
    }
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxBinOPRow(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *sonGb;
    int nn;

    assert(pg && pn && pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    for (nn = 1; nn < pn->nbsn; nn++) {
	symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, EmBuildEmGBoxNodeToString(pg, pn));
	symbGb->pFather = pgb;
	sonGb->pBrother = symbGb;
	sonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	symbGb->pBrother = sonGb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}

/* Like EmBuildEmGBoxBinOPRow but check for UMinus son to disable + symb
 */
static EmGBox *
EmBuildEmGBoxPlusRow(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *sonGb, *newSonGb;
    int nn;

    assert(pg && pn && pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    for (nn = 1; nn < pn->nbsn; nn++) {
	newSonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);
	if (newSonGb->type != GBUMinus) {
	    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, EmBuildEmGBoxNodeToString(pg, pn));
	    symbGb->pFather = pgb;
	    symbGb->pBrother = newSonGb;
	    sonGb->pBrother = symbGb;
	}
	else {
	    sonGb->pBrother = newSonGb;
	}
	sonGb = newSonGb;
	sonGb->pFather = pgb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}


/* Like EmBuildEmGBoxBinOPRow but check for implicit mult
 */
static EmGBox *
EmBuildEmGBoxMultRow(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *sonGb, *newSonGb;
    int nn;
    Bools showMult = True;

    assert(pg && pn && pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    if ((KlCTrueP(EmAGetC(pg, pn, "*impl-mult*"))) &&
	!(KlCTrueP(EmAGetC(pg, pn, "show-impl-mult"))))
	showMult = False;

    for (nn = 1; nn < pn->nbsn; nn++) {
	newSonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);

	if (showMult || (newSonGb->type == GBUMinus)) {
	    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBMultSymb, NULL);
	    symbGb->pFather = pgb;
	    symbGb->pBrother = newSonGb;
	    sonGb->pBrother = symbGb;
	}
	else {
	    sonGb->pBrother = newSonGb;
	}
	sonGb = newSonGb;
	sonGb->pFather = pgb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}


static EmGBox *
EmBuildEmGBoxUMinus(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *sonGb;

    assert(pg && pn && pn->nbsn == 1);
    pgb->type = GBUMinus;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, EmBuildEmGBoxNodeToString(pg, pn));
    symbGb->pFather = pgb;
    pgb->pSon = symbGb;
    symbGb->pBrother = sonGb;
    sonGb->pBrother = NULL;
    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxBinDiv(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *upGb, *botGb;

    assert(pg && pn && pn->nbsn == 2);
    pgb->type = GBDiv;

    upGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    upGb->pFather = pgb;
    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBHLine, NULL);
    symbGb->pFather = pgb;
    botGb = EmBuildEmGBox(pg, pn->d.aps[1]);
    botGb->pFather = pgb;

    pgb->pSon = upGb;
    upGb->pBrother = symbGb;
    symbGb->pBrother = botGb;
    botGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxEq(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *upGb, *botGb;

    assert(pg && pn && pn->nbsn == 2);
    pgb->type = GBRow;

    upGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    upGb->pFather = pgb;
    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, EmBuildEmGBoxNodeToString(pg, pn));
    symbGb->pFather = pgb;
    botGb = EmBuildEmGBox(pg, pn->d.aps[1]);
    botGb->pFather = pgb;

    pgb->pSon = upGb;
    upGb->pBrother = symbGb;
    symbGb->pBrother = botGb;
    botGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxIndex(EmGroup * pg, EmNode * pn, EmGBox * pgb, EmGBoxType type)
{
    EmGBox *indexBodyGb, *indexGb, *bodyGb, *tmpGb;

    assert(pg && pn && pn->nbsn == 2);
    pgb->type = GBIndex;

    bodyGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    indexBodyGb = EmBuildEmGBox(pg, pn->d.aps[1]);

    indexGb = EmAllocEmGBox();
    indexGb->type = type;
    indexGb->pn = pn;
    indexGb->h = indexGb->w = indexGb->x = indexGb->y = 0;
    indexGb->pFather = pgb;
    indexGb->pSon = indexBodyGb;
    indexBodyGb->pFather = indexGb;

    /*
     * that's the tricky part. avoid bad imbrication for up and down indices
     * must modify bodyGb EmGBox tree to cut one level of EmGBox
     */
    if ((bodyGb->type == GBIndex) && (indexGb->type != (bodyGb->pSon)->pBrother->type)) {
	tmpGb = pgb->pSon = bodyGb->pSon;
	while (tmpGb->pBrother) {
	    tmpGb->pFather = pgb;
	    tmpGb = tmpGb->pBrother;
	}
	tmpGb->pFather = pgb;
	tmpGb->pBrother = indexGb;
	EmFreeEmGBox(bodyGb);
    }
    else {
	pgb->pSon = bodyGb;
	bodyGb->pFather = pgb;
	bodyGb->pBrother = indexGb;
    }
    indexGb->pBrother = NULL;
    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxExp(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    return EmBuildEmGBoxIndex(pg, pn, pgb, GBUp);
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxInd(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    return EmBuildEmGBoxIndex(pg, pn, pgb, GBDown);
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxRoot(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *symbGb, *sonGb;

    pgb->type = GBRoot;

    symbGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBRootSymb, NULL);
    symbGb->pFather = pgb;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;

    pgb->pSon = symbGb;
    symbGb->pBrother = sonGb;
    sonGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxFunc(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *nameGb, *paramsGb, *sonGb;
    int i;

    assert(pg && pn && pn->nbsn);
    pgb->type = GBRow;

    nameGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    nameGb->pFather = pgb;
    pgb->pSon = nameGb;

    paramsGb = EmBuildEmGBox(pg, pn->d.aps[1]);
    paramsGb->pFather = pgb;
    nameGb->pBrother = paramsGb;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxColumn(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *oldSonGb, *sonGb = NULL;
    int nn;

    assert(pg && pn);
    pgb->type = GBColLeft;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	sonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    pgb->pSon = sonGb;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxVector(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *oldSonGb, *sonGb, *symbLeftGb, *symbRightGb;
    int nn;

    assert(pg && pn && pn->nbsn > 1);
    pgb->type = GBVector;

    symbLeftGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBSymb, "(");
    symbLeftGb->pFather = pgb;
    symbRightGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBSymb, ")");
    symbRightGb->pFather = pgb;
    symbLeftGb->pBrother = symbRightGb;
    pgb->pSon = symbLeftGb;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	sonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    symbRightGb->pBrother = oldSonGb;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxMatrix(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *oldSonGb, *sonGb, *symbLeftGb, *symbRightGb;
    int nn;

    assert(pg && pn && pn->nbsn > 1);
    pgb->type = GBMatrix;

    symbLeftGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBSymb, "(");
    symbLeftGb->pFather = pgb;
    symbRightGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBSymb, ")");
    symbRightGb->pFather = pgb;
    symbLeftGb->pBrother = symbRightGb;
    pgb->pSon = symbLeftGb;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	assert((pn->d.aps[nn]->type == NTVector) ||
	       (pn->d.aps[nn]->type == NTColumn));
	sonGb = EmBuildEmGBox(pg, pn->d.aps[nn]);

	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    symbRightGb->pBrother = oldSonGb;

    return pgb;
}

/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxParenth(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *paramsGb, *sonGb;
    int i;

    assert(pg && pn && (pn->nbsn > 0));
    pgb->type = GBRow;

    paramsGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, ")");
    paramsGb->pBrother = NULL;
    for (i = pn->nbsn - 1; i >= 0; i--) {
	sonGb = EmBuildEmGBox(pg, pn->d.aps[i]);
	sonGb->pFather = pgb;
	sonGb->pBrother = paramsGb;
	paramsGb = sonGb;
	if (i) {			/* that's not the first parameter so
					 * need a ',' */
	    sonGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, ",");
	    sonGb->pFather = pgb;
	    sonGb->pBrother = paramsGb;
	    paramsGb = sonGb;
	}
    }
    sonGb = EmBuildEmGBoxLeaf(pg, pn, NULL, GBChar, "(");
    sonGb->pFather = pgb;
    sonGb->pBrother = paramsGb;
    pgb->pSon = sonGb;
    return pgb;
}


/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxTemplate(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    pgb->type = GBTemplate;
    return pgb;
}


/* static function not documented...
 */
static EmGBox *
EmBuildEmGBoxContainer(EmGroup * pg, EmNode * pn, EmGBox * pgb)
{
    EmGBox *sonGb;

    assert(pg && pn && pn->nbsn == 1);
    pgb->type = GBContainer;

    sonGb = EmBuildEmGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    sonGb->pBrother = NULL;
    pgb->pSon = sonGb;
    return pgb;
}

/* Convert a formula into graphic boxes (GBox).
 *
 * Caller must fill pBrother and pFather fields of returned EmGBox.
 *
 * Return : a build EmGBox tree
 */
/* ??TODO add yield */
EmGBox *
EmBuildEmGBox(EmGroup * pg /* Group to use for attribs */ ,
	      EmNode * pn		/* Root node for the formula to
	          convert */ )
{
    EmBuildEmGBoxFuncType pf;
    EmGBox *pgb;

    assert(pg && pn);

    pgb = EmNodeToEmGBox(pg, pn);
    if (pgb) {
	if (!EmGBSonRebuildP(pgb) && !EmGBRebuildP(pgb)) {
/* printf("Tree not rebuild: "); EmPrintTree(pn); printf("\nlinked EmGBox tree: "); EmPrintGBTree(pgb); printf("\n");*/
	    return pgb;			/* this box (and its subtree) is
					 * already build */
	}
	else {
/*  printf("EmGBox unlinked: "); EmPrintGB(pgb); printf("\n");*/
	    EmUnLinkEmGBoxToNode(pg, pn, pgb);	/* must rebuild it */
	}
    }
    pgb = EmAllocEmGBox();
    pgb->pn = pn;

    /* need a build or rebuild for this EmNode */
    {
	char funcName[MAX_CHAR_TMP];

	strcpy(funcName, "NT");
	strcat(funcName, EmNodeTypeToString(pn->type));
	strcat(funcName, "BuildEmGBox");
	/* printf("Node build: ");	EmPrintEmNode(pn); printf("\n"); */
	pf = KlNumToPtr(EmAGetC(pg, pn, funcName));
    }
    /* hope this ^} will free stack allocated for funcName */
    if (!pf)
	UIError("EmBuildEmGBox", "unknown node-type %d", pn->type);

    pgb = pf(pg, pn, pgb);
    EmGBRebuildF(pgb);			/* build just done */
    EmGBRefillT(pgb);			/* after a rebuild need a refill */
    EmLinkEmGBoxToNode(pg, pn, pgb);
    printf("returned EmGBox tree:");
    EmPrintGBTree(pgb);
    printf("\n");
    return pgb;
}


/* Must fill all default attributes concerning building of EmGBoxes.
 */
void
EmGBoxFDABuild(EmGroup * pg /* Group to fill */ ,
	       EmNode * pn /* Node to fill */ )
{
    EmASetC(pg, pn, "NTDivBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxBinDiv));
    EmASetC(pg, pn, "NTPlusBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxPlusRow));
    EmASetC(pg, pn, "NTMultBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxMultRow));
    EmASetC(pg, pn, "NTUMinusBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxUMinus));
    EmASetC(pg, pn, "NTEqBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxEq));
    EmASetC(pg, pn, "NTPowBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxExp));
    EmASetC(pg, pn, "NTExpBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxExp));
    EmASetC(pg, pn, "NTSubBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxInd));
    EmASetC(pg, pn, "NTRootBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxRoot));
    EmASetC(pg, pn, "NTFuncBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxFunc));
    EmASetC(pg, pn, "NTColumnBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxColumn));
    EmASetC(pg, pn, "NTVectorBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxVector));
    EmASetC(pg, pn, "NTMatrixBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxMatrix));
    EmASetC(pg, pn, "NTStringBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxString));
    EmASetC(pg, pn, "NTSymbolBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxSymbol));
    EmASetC(pg, pn, "NTNumberBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxString));
    EmASetC(pg, pn, "NTParenthBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxParenth));
    EmASetC(pg, pn, "NTTemplateBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxTemplate));
    EmASetC(pg, pn, "NTContainerBuildEmGBox", KlNumPointerMake(EmBuildEmGBoxContainer));

}
