#include "emall.h"

/**************************************************************** Prototypes */


/******************************************************************** Bodies */

/* call a klone sexpr (used as generic action in the Xt translation manager)
 * set current-state of triggering window with the result of this eva
 * (set is done using set-state so a new xt-translation table is pluged in
 * if needed)
 */
void
EmCallKloneFromXttm(Widget wid		/* widget from which translation has
		        been initiated */ ,
		    XEvent * xev	/* X event which triggered
		        translation */ ,
		    String * args	/* args found in action. ie: the
		        klone sexpr to evaluate */ ,
		    Cardinal * numArgs /* must be 1 */ )
{
    XEvent *pXEvent;
    KlO newState, curState, reso;
    EmGroup *pg;

    assert(*numArgs == 1);
    pXEvent = UNew(XEvent);
    *pXEvent = *xev;

    /* call function given as action in the emtranslation-table */
    /* this function is given as args to EmCallKloneFromXttm */
    pg = EmWidToGroup(wid);
    curState = EmAGetC(pg, EmGateNode, "*current-state*");
    printf("call: %s\n", args[0]);
    newState = KlApply3(KlIntern(args[0]), KlNumberMake(pg), curState, KlStructMake(EmXEventClassArray[pXEvent->type], pXEvent));

    /* if state has changed reset it with set-state */
    if ((reso = KlSend_equal(newState, curState)) == NIL) {
	KlApply3(KlIntern("set-state"), KlNumberMake(pg), curState, newState);
    }
    else {
	/* if state is unchaged event MUST be gobbled (or infinite loop) */
	EmASetLocalC(KlNumToGrp(pg), (EmNode *) NULL, "*dont-gobble-event*", NIL);
	printf("state unchanged\n");
    }
}


/* Init the event module.
 */
void
EmEventInit()
{
}
