#include "emall.h"

static GBox *gboxGarbage = NULL;
static int gboxGarbageCount = 0;



/**************************************************************** Prototypes */

/* static function not documented...
 */
static GBox *EmBuildGBoxLeaf(EmGroup * pg, EmNode * pn, GBox * pgb, GBoxType type, void *pVal);

/* static function not documented...
 */
static GBox *EmBuildGBoxString(EmGroup * pg, EmNode * pn, GBox * pgb);
static GBox *EmBuildGBoxSymbol(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static char *EmBuildGBoxNodeToString(EmGroup * pg, EmNode * pn);

/* static function not documented...
 */
static GBox *EmBuildGBoxBinOPRow(EmGroup * pg, EmNode * pn, GBox * pgb);

/* Like EmBuildGBoxBinOPRow but check for UMinus son to disable + symb
 */
static GBox *EmBuildGBoxPlusRow(EmGroup * pg, EmNode * pn, GBox * pgb);

/* Like EmBuildGBoxBinOPRow but check for implicit mult
 */
static GBox *EmBuildGBoxMultRow(EmGroup * pg, EmNode * pn, GBox * pgb);
static GBox *EmBuildGBoxUMinus(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxBinDiv(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxEq(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxIndex(EmGroup * pg, EmNode * pn, GBox * pgb, GBoxType type);

/* static function not documented...
 */
static GBox *EmBuildGBoxExp(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxInd(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxRoot(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxFunc(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxColumn(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxVector(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxMatrix(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxParenth(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxTemplate(EmGroup * pg, EmNode * pn, GBox * pgb);

/* static function not documented...
 */
static GBox *EmBuildGBoxContainer(EmGroup * pg, EmNode * pn, GBox * pgb);

/******************************************************************** Bodies */


/* Print a GBox state (human redably ;)
 */
void
EmPrintGBState(GBox * pgb)
{
    if (EmGBRebuildP(pgb))
	printf("Rebuild ");
    if (EmGBSonRebuildP(pgb))
	printf("SonRebuild ");
    if (EmGBRefillP(pgb))
	printf("Refill ");
    if (EmGBRedrawP(pgb))
	printf("Redraw ");
    if (EmGBDiscardedP(pgb))
	printf("Discarded ");
    if (EmGBCachedP(pgb))
	printf("Cached ");
}

/* Print a short description of a given GBox
 */
void
EmPrintGB(GBox * pgb)
{
    printf("(type:%d /", pgb->type);
    EmPrintGBState(pgb);
    printf(")");
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxLeaf(EmGroup * pg, EmNode * pn, GBox * pgb, GBoxType type, void *pVal)
{
    if (!pgb)
	pgb = EmAllocGBox();
    pgb->type = type;
    pgb->pn = pn;
    pgb->pVal = pVal;
    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxString(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *charGb, *charTmpGb;
    char *p;
    int i;
    EmNode *psn;

    pgb->type = GBRow;

    charTmpGb = NULL;
    for (i = EmNbSonNodes(pn); i > 0; i--) {
	psn = EmNthSonNode(pn, i - 1);
	if (psn->nbsn) {
	    /* special case of String son of String */
	    charGb = EmBuildGBox(pg, psn);
	}
	else {
	    p = KlStringToCharPtr(psn->d.value);
	    charGb = EmBuildGBoxLeaf(pg, psn, NULL, GBChar, p);
	}
	charGb->pBrother = charTmpGb;
	charTmpGb = charGb;
	charGb->pFather = pgb;
    }
    pgb->pSon = charGb;

    return pgb;
}

static GBox *
EmBuildGBoxSymbol(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    return EmBuildGBoxLeaf(pg, pn, pgb, GBChar, "Z");
}

/* static function not documented...
 */
static char *
EmBuildGBoxNodeToString(EmGroup * pg, EmNode * pn)
{
    switch (pn->type) {
	case NTUMinus:
	return "-";
    case NTPlus:
	return "+";
    case NTMult:
	return "*";
    case NTDiv:
	return "/";
    case NTEq:
	return "=";
    default:
	return "@";
    }
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxBinOPRow(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *sonGb;
    int nn;

    assert(pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    for (nn = 1; nn < pn->nbsn; nn++) {
	symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, EmBuildGBoxNodeToString(pg, pn));
	symbGb->pFather = pgb;
	sonGb->pBrother = symbGb;
	sonGb = EmBuildGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	symbGb->pBrother = sonGb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}

/* Like EmBuildGBoxBinOPRow but check for UMinus son to disable + symb
 */
static GBox *
EmBuildGBoxPlusRow(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *sonGb, *newSonGb;
    int nn;

    assert(pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    for (nn = 1; nn < pn->nbsn; nn++) {
	newSonGb = EmBuildGBox(pg, pn->d.aps[nn]);
	if (newSonGb->type != GBUMinus) {
	    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, EmBuildGBoxNodeToString(pg, pn));
	    symbGb->pFather = pgb;
	    symbGb->pBrother = newSonGb;
	    sonGb->pBrother = symbGb;
	}
	else {
	    sonGb->pBrother = newSonGb;
	}
	sonGb = newSonGb;
	sonGb->pFather = pgb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}


/* Like EmBuildGBoxBinOPRow but check for implicit mult
 */
static GBox *
EmBuildGBoxMultRow(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *sonGb, *newSonGb;
    int nn;
    Bools showMult = True;

    assert(pn->nbsn > 1);
    pgb->type = GBRow;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    pgb->pSon = sonGb;
    if ((KlCTrueP(EmAGetC(pg, pn, "*impl-mult*"))) &&
	!(KlCTrueP(EmAGetC(pg, pn, "show-impl-mult"))))
	showMult = False;

    for (nn = 1; nn < pn->nbsn; nn++) {
	newSonGb = EmBuildGBox(pg, pn->d.aps[nn]);

	if (showMult || (newSonGb->type == GBUMinus)) {
	    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBMultSymb, NULL);
	    symbGb->pFather = pgb;
	    symbGb->pBrother = newSonGb;
	    sonGb->pBrother = symbGb;
	}
	else {
	    sonGb->pBrother = newSonGb;
	}
	sonGb = newSonGb;
	sonGb->pFather = pgb;
    }
    sonGb->pBrother = NULL;
    return pgb;
}


static GBox *
EmBuildGBoxUMinus(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *sonGb;

    assert(pn->nbsn == 1);
    pgb->type = GBUMinus;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, EmBuildGBoxNodeToString(pg, pn));
    symbGb->pFather = pgb;
    pgb->pSon = symbGb;
    symbGb->pBrother = sonGb;
    sonGb->pBrother = NULL;
    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxBinDiv(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *upGb, *botGb;

    assert(pn->nbsn == 2);
    pgb->type = GBDiv;

    upGb = EmBuildGBox(pg, pn->d.aps[0]);
    upGb->pFather = pgb;
    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBHLine, NULL);
    symbGb->pFather = pgb;
    botGb = EmBuildGBox(pg, pn->d.aps[1]);
    botGb->pFather = pgb;

    pgb->pSon = upGb;
    upGb->pBrother = symbGb;
    symbGb->pBrother = botGb;
    botGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxEq(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *upGb, *botGb;

    assert(pn->nbsn == 2);
    pgb->type = GBRow;

    upGb = EmBuildGBox(pg, pn->d.aps[0]);
    upGb->pFather = pgb;
    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, EmBuildGBoxNodeToString(pg, pn));
    symbGb->pFather = pgb;
    botGb = EmBuildGBox(pg, pn->d.aps[1]);
    botGb->pFather = pgb;

    pgb->pSon = upGb;
    upGb->pBrother = symbGb;
    symbGb->pBrother = botGb;
    botGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxIndex(EmGroup * pg, EmNode * pn, GBox * pgb, GBoxType type)
{
    GBox *indexBodyGb, *indexGb, *bodyGb, *tmpGb;

    assert(pn->nbsn == 2);
    pgb->type = GBIndex;

    bodyGb = EmBuildGBox(pg, pn->d.aps[0]);
    indexBodyGb = EmBuildGBox(pg, pn->d.aps[1]);

    indexGb = EmAllocGBox();
    indexGb->type = type;
    indexGb->pn = pn;
    indexGb->h = indexGb->w = indexGb->x = indexGb->y = 0;
    indexGb->pFather = pgb;
    indexGb->pSon = indexBodyGb;
    indexBodyGb->pFather = indexGb;

    /*
     * that's the tricky part. avoid bad imbrication for up and down indices
     * must modify bodyGb gbox tree to cut one level of gbox
     */
    if ((bodyGb->type == GBIndex) && (indexGb->type != (bodyGb->pSon)->pBrother->type)) {
	tmpGb = pgb->pSon = bodyGb->pSon;
	while (tmpGb->pBrother) {
	    tmpGb->pFather = pgb;
	    tmpGb = tmpGb->pBrother;
	}
	tmpGb->pFather = pgb;
	tmpGb->pBrother = indexGb;
	EmFreeGBox(bodyGb);
    }
    else {
	pgb->pSon = bodyGb;
	bodyGb->pFather = pgb;
	bodyGb->pBrother = indexGb;
    }
    indexGb->pBrother = NULL;
    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxExp(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    return EmBuildGBoxIndex(pg, pn, pgb, GBUp);
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxInd(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    return EmBuildGBoxIndex(pg, pn, pgb, GBDown);
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxRoot(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *symbGb, *sonGb;

    pgb->type = GBRoot;

    symbGb = EmBuildGBoxLeaf(pg, pn, NULL, GBRootSymb, NULL);
    symbGb->pFather = pgb;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;

    pgb->pSon = symbGb;
    symbGb->pBrother = sonGb;
    sonGb->pBrother = NULL;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxFunc(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *nameGb, *paramsGb, *sonGb;
    int i;

    assert(pn->nbsn);
    pgb->type = GBRow;

    nameGb = EmBuildGBox(pg, pn->d.aps[0]);
    nameGb->pFather = pgb;
    pgb->pSon = nameGb;

    paramsGb = EmBuildGBox(pg, pn->d.aps[1]);
    paramsGb->pFather = pgb;
    nameGb->pBrother = paramsGb;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxColumn(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *oldSonGb, *sonGb = NULL;
    int nn;

    assert(pg);
    pgb->type = GBColLeft;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	sonGb = EmBuildGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    pgb->pSon = sonGb;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxVector(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *oldSonGb, *sonGb, *symbLeftGb, *symbRightGb;
    int nn;

    assert(pn->nbsn > 1);
    pgb->type = GBVector;

    symbLeftGb = EmBuildGBoxLeaf(pg, pn, NULL, GBSymb, "(");
    symbLeftGb->pFather = pgb;
    symbRightGb = EmBuildGBoxLeaf(pg, pn, NULL, GBSymb, ")");
    symbRightGb->pFather = pgb;
    symbLeftGb->pBrother = symbRightGb;
    pgb->pSon = symbLeftGb;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	sonGb = EmBuildGBox(pg, pn->d.aps[nn]);
	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    symbRightGb->pBrother = oldSonGb;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxMatrix(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *oldSonGb, *sonGb, *symbLeftGb, *symbRightGb;
    int nn;

    assert(pn->nbsn > 1);
    pgb->type = GBMatrix;

    symbLeftGb = EmBuildGBoxLeaf(pg, pn, NULL, GBSymb, "(");
    symbLeftGb->pFather = pgb;
    symbRightGb = EmBuildGBoxLeaf(pg, pn, NULL, GBSymb, ")");
    symbRightGb->pFather = pgb;
    symbLeftGb->pBrother = symbRightGb;
    pgb->pSon = symbLeftGb;

    oldSonGb = NULL;
    for (nn = pn->nbsn - 1; nn >= 0; nn--) {
	assert((pn->d.aps[nn]->type == NTVector) ||
	       (pn->d.aps[nn]->type == NTColumn));
	sonGb = EmBuildGBox(pg, pn->d.aps[nn]);

	sonGb->pFather = pgb;
	sonGb->pBrother = oldSonGb;
	oldSonGb = sonGb;
    }
    symbRightGb->pBrother = oldSonGb;

    return pgb;
}

/* static function not documented...
 */
static GBox *
EmBuildGBoxParenth(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *paramsGb, *sonGb;
    int i;

    assert(pn && (pn->nbsn > 0));
    pgb->type = GBRow;

    paramsGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, ")");
    paramsGb->pBrother = NULL;
    for (i = pn->nbsn - 1; i >= 0; i--) {
	sonGb = EmBuildGBox(pg, pn->d.aps[i]);
	sonGb->pFather = pgb;
	sonGb->pBrother = paramsGb;
	paramsGb = sonGb;
	if (i) {			/* that's not the first parameter so
					 * need a ',' */
	    sonGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, ",");
	    sonGb->pFather = pgb;
	    sonGb->pBrother = paramsGb;
	    paramsGb = sonGb;
	}
    }
    sonGb = EmBuildGBoxLeaf(pg, pn, NULL, GBChar, "(");
    sonGb->pFather = pgb;
    sonGb->pBrother = paramsGb;
    pgb->pSon = sonGb;
    return pgb;
}


/* static function not documented...
 */
static GBox *
EmBuildGBoxTemplate(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    pgb->type = GBTemplate;
    return pgb;
}


/* static function not documented...
 */
static GBox *
EmBuildGBoxContainer(EmGroup * pg, EmNode * pn, GBox * pgb)
{
    GBox *sonGb;

    assert(pn->nbsn == 1);
    pgb->type = GBContainer;

    sonGb = EmBuildGBox(pg, pn->d.aps[0]);
    sonGb->pFather = pgb;
    sonGb->pBrother = NULL;
    pgb->pSon = sonGb;
    return pgb;
}

/* Convert a formula into graphic boxes (GBox).
 *
 * Caller must fill pBrother and pFather fields of returned GBox.
 *
 * Return : a filled Gbox tree
 */
/* ??TODO add yield */
GBox *
EmBuildGBox(EmGroup * pg /* Group to use for attribs */ ,
	    EmNode * pn			/* Root node for the formula to
	        convert */ )
{
    EmBuildGBoxFuncType pf;
    GBox *pgb;

    assert(pg && pn);

    pgb = EmNodeToGBox(pg, pn);
    if (pgb) {
	if (!EmGBSonRebuildP(pgb) && !EmGBRebuildP(pgb)) {
	    printf("Tree not rebuild :");
	    EmPrintTree(pn);
	    printf("\n");
	    return pgb;			/* this box (and its subtree) is
					 * already build */
	}
	else {
	    EmUnLinkGBoxToNode(pg, pn, pgb);	/* must rebuild it */
	}
    }
    else {				/* this a really new GBox */
	pgb = EmAllocGBox();
	pgb->pn = pn;
    }

    /* need a build or rebuild for this EmNode */
    {
	char funcName[MAX_CHAR_TMP];

	strcpy(funcName, "NT");
	strcat(funcName, EmNodeTypeToString(pn->type));
	strcat(funcName, "BuildGBox");
	printf("Node build :");
	EmPrintEmNode(pn);
	printf("\n");
	pf = KlNumToPtr(EmAGetC(pg, pn, funcName));
    }					/* hope this will free stack
					 * allocated for funcName */
    pgb = pf(pg, pn, pgb);
    EmGBRebuildF(pgb);			/* build just done */
    EmGBRefillT(pgb);			/* after a rebuild need a refill */
    EmLinkGBoxToNode(pg, pn, pgb);
    return pgb;
}


/* Must fill all default attributes concerning building of GBoxes.
 */
void
EmGBoxFDABuild(EmGroup * pg /* Group to fill */ ,
	       EmNode * pn /* Node to fill */ )
{
    EmASetC(pg, pn, "NTDivBuildGBox", KlNumPointerMake(EmBuildGBoxBinDiv));
    EmASetC(pg, pn, "NTPlusBuildGBox", KlNumPointerMake(EmBuildGBoxPlusRow));
    EmASetC(pg, pn, "NTMultBuildGBox", KlNumPointerMake(EmBuildGBoxMultRow));
    EmASetC(pg, pn, "NTUMinusBuildGBox", KlNumPointerMake(EmBuildGBoxUMinus));
    EmASetC(pg, pn, "NTEqBuildGBox", KlNumPointerMake(EmBuildGBoxEq));
    EmASetC(pg, pn, "NTPowBuildGBox", KlNumPointerMake(EmBuildGBoxExp));
    EmASetC(pg, pn, "NTExpBuildGBox", KlNumPointerMake(EmBuildGBoxExp));
    EmASetC(pg, pn, "NTSubBuildGBox", KlNumPointerMake(EmBuildGBoxInd));
    EmASetC(pg, pn, "NTRootBuildGBox", KlNumPointerMake(EmBuildGBoxRoot));
    EmASetC(pg, pn, "NTFuncBuildGBox", KlNumPointerMake(EmBuildGBoxFunc));
    EmASetC(pg, pn, "NTColumnBuildGBox", KlNumPointerMake(EmBuildGBoxColumn));
    EmASetC(pg, pn, "NTVectorBuildGBox", KlNumPointerMake(EmBuildGBoxVector));
    EmASetC(pg, pn, "NTMatrixBuildGBox", KlNumPointerMake(EmBuildGBoxMatrix));
    EmASetC(pg, pn, "NTStringBuildGBox", KlNumPointerMake(EmBuildGBoxString));
    EmASetC(pg, pn, "NTSymbolBuildGBox", KlNumPointerMake(EmBuildGBoxSymbol));
    EmASetC(pg, pn, "NTNumberBuildGBox", KlNumPointerMake(EmBuildGBoxString));
    EmASetC(pg, pn, "NTParenthBuildGBox", KlNumPointerMake(EmBuildGBoxParenth));
    EmASetC(pg, pn, "NTTemplateBuildGBox", KlNumPointerMake(EmBuildGBoxTemplate));
    EmASetC(pg, pn, "NTContainerBuildGBox", KlNumPointerMake(EmBuildGBoxContainer));

}
